/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.BodyParser;
import com.firefly.codec.http2.decode.HeaderBlockFragments;
import com.firefly.codec.http2.decode.HeaderBlockParser;
import com.firefly.codec.http2.decode.HeaderParser;
import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.model.MetaData;
import java.nio.ByteBuffer;

public class ContinuationBodyParser
extends BodyParser {
    private final HeaderBlockParser headerBlockParser;
    private final HeaderBlockFragments headerBlockFragments;
    private State state = State.PREPARE;
    private int length;

    public ContinuationBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser, HeaderBlockFragments headerBlockFragments) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
        this.headerBlockFragments = headerBlockFragments;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        if (this.hasFlag(4)) {
            this.onHeaders();
        }
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() == 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_frame");
                    }
                    if (this.getStreamId() != this.headerBlockFragments.getStreamId()) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_stream");
                    }
                    this.length = this.getBodyLength();
                    this.state = State.FRAGMENT;
                    continue block4;
                }
                case FRAGMENT: {
                    int remaining = buffer.remaining();
                    if (remaining < this.length) {
                        this.headerBlockFragments.storeFragment(buffer, remaining, false);
                        this.length -= remaining;
                        continue block4;
                    }
                    boolean last = this.hasFlag(4);
                    this.headerBlockFragments.storeFragment(buffer, this.length, last);
                    this.reset();
                    if (last) {
                        this.onHeaders();
                    }
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onHeaders() {
        ByteBuffer headerBlock = this.headerBlockFragments.complete();
        MetaData metaData = this.headerBlockParser.parse(headerBlock, headerBlock.remaining());
        HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, this.headerBlockFragments.getPriorityFrame(), this.headerBlockFragments.isEndStream());
        this.notifyHeaders(frame);
    }

    private void reset() {
        this.state = State.PREPARE;
        this.length = 0;
    }

    private static enum State {
        PREPARE,
        FRAGMENT;

    }
}

