/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.HeaderParser;
import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.GoAwayFrame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PingFrame;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BodyParser {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final HeaderParser headerParser;
    private final Parser.Listener listener;

    protected BodyParser(HeaderParser headerParser, Parser.Listener listener) {
        this.headerParser = headerParser;
        this.listener = listener;
    }

    public abstract boolean parse(ByteBuffer var1);

    protected void emptyBody(ByteBuffer buffer) {
        this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_frame");
    }

    protected boolean hasFlag(int bit) {
        return this.headerParser.hasFlag(bit);
    }

    protected boolean isPadding() {
        return this.headerParser.hasFlag(8);
    }

    protected boolean isEndStream() {
        return this.headerParser.hasFlag(1);
    }

    protected int getStreamId() {
        return this.headerParser.getStreamId();
    }

    protected int getBodyLength() {
        return this.headerParser.getLength();
    }

    protected void notifyData(DataFrame frame) {
        try {
            this.listener.onData(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyHeaders(HeadersFrame frame) {
        try {
            this.listener.onHeaders(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyPriority(PriorityFrame frame) {
        try {
            this.listener.onPriority(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyReset(ResetFrame frame) {
        try {
            this.listener.onReset(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifySettings(SettingsFrame frame) {
        try {
            this.listener.onSettings(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyPushPromise(PushPromiseFrame frame) {
        try {
            this.listener.onPushPromise(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyPing(PingFrame frame) {
        try {
            this.listener.onPing(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyGoAway(GoAwayFrame frame) {
        try {
            this.listener.onGoAway(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected void notifyWindowUpdate(WindowUpdateFrame frame) {
        try {
            this.listener.onWindowUpdate(frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    protected boolean connectionFailure(ByteBuffer buffer, int error, String reason) {
        BufferUtils.clear((ByteBuffer)buffer);
        this.notifyConnectionFailure(error, reason);
        return false;
    }

    private void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }
}

