/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.codec.http2.model.Cookie;
import com.firefly.codec.http2.model.CookieParser;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.json.Json;
import com.firefly.utils.json.JsonArray;
import com.firefly.utils.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SimpleResponse {
    MetaData.Response response;
    List<ByteBuffer> responseBody = new ArrayList<ByteBuffer>();
    List<Cookie> cookies;
    String stringBody;

    public SimpleResponse(MetaData.Response response) {
        this.response = response;
    }

    public HttpVersion getHttpVersion() {
        return this.response.getHttpVersion();
    }

    public HttpFields getFields() {
        return this.response.getFields();
    }

    public long getContentLength() {
        return this.response.getContentLength();
    }

    public Iterator<HttpField> iterator() {
        return this.response.iterator();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getReason() {
        return this.response.getReason();
    }

    public void forEach(Consumer<? super HttpField> action) {
        this.response.forEach(action);
    }

    public Spliterator<HttpField> spliterator() {
        return this.response.spliterator();
    }

    public MetaData.Response getResponse() {
        return this.response;
    }

    public List<ByteBuffer> getResponseBody() {
        return this.responseBody;
    }

    public String getStringBody() {
        return this.getStringBody("UTF-8");
    }

    public String getStringBody(String charset) {
        if (this.stringBody == null) {
            this.stringBody = BufferUtils.toString(this.responseBody, (String)charset);
            return this.stringBody;
        }
        return this.stringBody;
    }

    public <T> T getJsonBody(Class<T> clazz) {
        return (T)Json.toObject((String)this.getStringBody(), clazz);
    }

    public JsonObject getJsonObjectBody() {
        return Json.toJsonObject((String)this.getStringBody());
    }

    public JsonArray getJsonArrayBody() {
        return Json.toJsonArray((String)this.getStringBody());
    }

    public List<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.response.getFields().getValuesList(HttpHeader.SET_COOKIE.asString()).stream().map(CookieParser::parseSetCookie).collect(Collectors.toList());
            return this.cookies;
        }
        return this.cookies;
    }
}

