/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientHTTPHandler;
import com.firefly.client.http2.HTTP2Client;
import com.firefly.client.http2.HTTPClientConnection;
import com.firefly.client.http2.SimpleHTTPClientConfiguration;
import com.firefly.client.http2.SimpleResponse;
import com.firefly.codec.http2.model.BadMessageException;
import com.firefly.codec.http2.model.Cookie;
import com.firefly.codec.http2.model.CookieGenerator;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpFields;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpMethod;
import com.firefly.codec.http2.model.HttpURI;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.model.MimeTypes;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action2;
import com.firefly.utils.function.Action3;
import com.firefly.utils.function.Action4;
import com.firefly.utils.function.Action6;
import com.firefly.utils.function.Func4;
import com.firefly.utils.function.Func5;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.io.EofException;
import com.firefly.utils.io.IO;
import com.firefly.utils.json.Json;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.lang.pool.AsynchronousPool;
import com.firefly.utils.lang.pool.BoundedAsynchronousPool;
import com.firefly.utils.lang.pool.PooledObject;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHTTPClient
extends AbstractLifeCycle {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static Logger monitor = LoggerFactory.getLogger((String)"firefly-monitor");
    private final HTTP2Client http2Client;
    private final ConcurrentHashMap<RequestBuilder, AsynchronousPool<HTTPClientConnection>> poolMap = new ConcurrentHashMap();
    private final SimpleHTTPClientConfiguration simpleHTTPClientConfiguration;

    public SimpleHTTPClient() {
        this(new SimpleHTTPClientConfiguration());
    }

    public SimpleHTTPClient(SimpleHTTPClientConfiguration http2Configuration) {
        this.simpleHTTPClientConfiguration = http2Configuration;
        this.http2Client = new HTTP2Client(http2Configuration);
        this.start();
    }

    public void removeConnectionPool(String url) {
        try {
            this.removeConnectionPool(new URL(url));
        }
        catch (MalformedURLException e) {
            log.error("url exception", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public void removeConnectionPool(URL url) {
        RequestBuilder req = new RequestBuilder();
        req.host = url.getHost();
        req.port = url.getPort() < 0 ? url.getDefaultPort() : url.getPort();
        this.removePool(req);
    }

    public void removeConnectionPool(String host, int port) {
        RequestBuilder req = new RequestBuilder();
        req.host = host;
        req.port = port;
        this.removePool(req);
    }

    private void removePool(RequestBuilder req) {
        AsynchronousPool<HTTPClientConnection> pool = this.poolMap.remove(req);
        pool.stop();
    }

    public int getConnectionPoolSize(String host, int port) {
        RequestBuilder req = new RequestBuilder();
        req.host = host;
        req.port = port;
        return this._getPoolSize(req);
    }

    public int getConnectionPoolSize(String url) {
        try {
            return this.getConnectionPoolSize(new URL(url));
        }
        catch (MalformedURLException e) {
            log.error("url exception", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public int getConnectionPoolSize(URL url) {
        RequestBuilder req = new RequestBuilder();
        req.host = url.getHost();
        req.port = url.getPort() < 0 ? url.getDefaultPort() : url.getPort();
        return this._getPoolSize(req);
    }

    private int _getPoolSize(RequestBuilder req) {
        AsynchronousPool<HTTPClientConnection> pool = this.poolMap.get(req);
        if (pool != null) {
            return pool.size();
        }
        return 0;
    }

    public RequestBuilder get(String url) {
        return this.request(HttpMethod.GET.asString(), url);
    }

    public RequestBuilder post(String url) {
        return this.request(HttpMethod.POST.asString(), url);
    }

    public RequestBuilder head(String url) {
        return this.request(HttpMethod.HEAD.asString(), url);
    }

    public RequestBuilder put(String url) {
        return this.request(HttpMethod.PUT.asString(), url);
    }

    public RequestBuilder delete(String url) {
        return this.request(HttpMethod.DELETE.asString(), url);
    }

    public RequestBuilder request(HttpMethod method, String url) {
        return this.request(method.asString(), url);
    }

    public RequestBuilder request(String method, String url) {
        try {
            return this.request(method, new URL(url));
        }
        catch (MalformedURLException e) {
            log.error("url exception", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public RequestBuilder request(String method, URL url) {
        try {
            RequestBuilder req = new RequestBuilder();
            req.host = url.getHost();
            req.port = url.getPort() < 0 ? url.getDefaultPort() : url.getPort();
            req.request = new MetaData.Request(method, new HttpURI(url.toURI()), HttpVersion.HTTP_1_1, new HttpFields());
            return req;
        }
        catch (URISyntaxException e) {
            log.error("url exception", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    protected void send(final RequestBuilder r) {
        long start = Millisecond100Clock.currentTimeMillis();
        AsynchronousPool<HTTPClientConnection> pool = this.getPool(r);
        pool.take().thenAccept(o -> {
            HTTPClientConnection connection = (HTTPClientConnection)o.getObject();
            connection.closedListener((Action1<HTTPConnection>)((Action1)conn -> pool.release(o))).exceptionListener((Action2<HTTPConnection, Throwable>)((Action2)(conn, exception) -> pool.release(o)));
            if (connection.getHttpVersion() == HttpVersion.HTTP_2) {
                pool.release(o);
            }
            log.debug("take the connection {} from pool, released: {}", (Object)connection.getSessionId(), (Object)o.isReleased());
            ClientHTTPHandler.Adapter handler = new ClientHTTPHandler.Adapter().headerComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(req, resp, outputStream, conn) -> {
                if (r.headerComplete != null) {
                    r.headerComplete.call(resp);
                }
                if (r.future != null && r.simpleResponse == null) {
                    r.simpleResponse = new SimpleResponse((MetaData.Response)resp);
                }
                return false;
            })).content((Func5<ByteBuffer, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func5)(buffer, req, resp, outputStream, conn) -> {
                if (r.content != null) {
                    r.content.call(buffer);
                }
                if (r.future != null && r.simpleResponse != null) {
                    r.simpleResponse.responseBody.add((ByteBuffer)buffer);
                }
                return false;
            })).contentComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(req, resp, outputStream, conn) -> {
                if (r.contentComplete != null) {
                    r.contentComplete.call(resp);
                }
                return false;
            })).messageComplete((Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean>)((Func4)(req, resp, outputStream, conn) -> {
                pool.release(o);
                log.debug("complete request of the connection {} , released: {}", (Object)connection.getSessionId(), (Object)o.isReleased());
                if (r.messageComplete != null) {
                    r.messageComplete.call(resp);
                }
                if (r.future != null) {
                    r.future.succeeded((Object)r.simpleResponse);
                }
                return true;
            })).badMessage((Action6<Integer, String, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection>)((Action6)(errCode, reason, req, resp, outputStream, conn) -> {
                pool.release(o);
                log.debug("bad message of the connection {} , released: {}", (Object)connection.getSessionId(), (Object)o.isReleased());
                if (r.badMessage != null) {
                    r.badMessage.call(errCode, reason, resp);
                }
                if (r.future != null) {
                    if (r.simpleResponse == null) {
                        r.simpleResponse = new SimpleResponse((MetaData.Response)resp);
                    }
                    r.future.failed((Throwable)new BadMessageException((int)errCode, (String)reason));
                }
                if (r.badMessage == null && r.future == null) {
                    IO.close((Closeable)((Closeable)o.getObject()));
                }
            })).earlyEOF((Action4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection>)((Action4)(req, resp, outputStream, conn) -> {
                pool.release(o);
                log.debug("eafly EOF of the connection {} , released: {}", (Object)connection.getSessionId(), (Object)o.isReleased());
                if (r.earlyEof != null) {
                    r.earlyEof.call(resp);
                }
                if (r.future != null) {
                    if (r.simpleResponse == null) {
                        r.simpleResponse = new SimpleResponse((MetaData.Response)resp);
                    }
                    r.future.failed((Throwable)new EofException("early eof"));
                }
                if (r.earlyEof == null && r.future == null) {
                    IO.close((Closeable)((Closeable)o.getObject()));
                }
            }));
            if (r.requestBody != null && !r.requestBody.isEmpty()) {
                connection.send(r.request, r.requestBody.toArray(BufferUtils.EMPTY_BYTE_BUFFER_ARRAY), (ClientHTTPHandler)handler);
            } else if (r.promise != null) {
                connection.send(r.request, r.promise, (ClientHTTPHandler)handler);
            } else if (r.output != null) {
                Promise<HTTPOutputStream> p = new Promise<HTTPOutputStream>(){

                    public void succeeded(HTTPOutputStream out) {
                        r.output.call((Object)out);
                    }
                };
                connection.send(r.request, p, (ClientHTTPHandler)handler);
            } else {
                connection.send(r.request, handler);
            }
            long end = Millisecond100Clock.currentTimeMillis();
            monitor.info("SimpleHTTPClient take connection {} total time: {}", (Object)connection.getSessionId(), (Object)(end - start));
        }).exceptionally(e -> {
            log.error("SimpleHTTPClient sends message exception", e);
            return null;
        });
    }

    private AsynchronousPool<HTTPClientConnection> getPool(RequestBuilder request) {
        return this.poolMap.computeIfAbsent(request, req -> new BoundedAsynchronousPool(this.simpleHTTPClientConfiguration.getPoolSize(), this.simpleHTTPClientConfiguration.getConnectTimeout(), () -> {
            Promise.Completable r = new Promise.Completable();
            Promise.Completable<HTTPClientConnection> c = this.http2Client.connect(request.host, request.port);
            c.thenAccept(conn -> r.succeeded((Object)new PooledObject(conn))).exceptionally(e -> {
                r.failed(e);
                return null;
            });
            return r;
        }, o -> ((HTTPClientConnection)o.getObject()).isOpen(), o -> {
            try {
                ((HTTPClientConnection)o.getObject()).close();
            }
            catch (IOException e) {
                log.error("close http connection exception", (Throwable)e);
            }
        }));
    }

    protected void init() {
    }

    protected void destroy() {
        this.http2Client.stop();
        this.poolMap.forEach((k, v) -> v.stop());
    }

    public class RequestBuilder {
        String host;
        int port;
        MetaData.Request request;
        List<ByteBuffer> requestBody = new ArrayList<ByteBuffer>();
        Action1<MetaData.Response> headerComplete;
        Action1<ByteBuffer> content;
        Action1<MetaData.Response> contentComplete;
        Action1<MetaData.Response> messageComplete;
        Action3<Integer, String, MetaData.Response> badMessage;
        Action1<MetaData.Response> earlyEof;
        Promise<HTTPOutputStream> promise;
        Action1<HTTPOutputStream> output;
        Promise.Completable<SimpleResponse> future;
        SimpleResponse simpleResponse;

        public RequestBuilder cookies(List<Cookie> cookies) {
            this.request.getFields().put(HttpHeader.COOKIE, CookieGenerator.generateCookies(cookies));
            return this;
        }

        public RequestBuilder put(String name, List<String> list) {
            this.request.getFields().put(name, list);
            return this;
        }

        public RequestBuilder put(HttpHeader header, String value) {
            this.request.getFields().put(header, value);
            return this;
        }

        public RequestBuilder put(String name, String value) {
            this.request.getFields().put(name, value);
            return this;
        }

        public RequestBuilder put(HttpField field) {
            this.request.getFields().put(field);
            return this;
        }

        public RequestBuilder addAll(HttpFields fields) {
            this.request.getFields().addAll(fields);
            return this;
        }

        public RequestBuilder add(HttpField field) {
            this.request.getFields().add(field);
            return this;
        }

        public RequestBuilder jsonBody(Object obj) {
            return this.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.APPLICATION_JSON.asString()).body(Json.toJson((Object)obj));
        }

        public RequestBuilder body(String content) {
            return this.body(content, StandardCharsets.UTF_8);
        }

        public RequestBuilder body(String content, Charset charset) {
            return this.write(BufferUtils.toBuffer((String)content, (Charset)charset));
        }

        public RequestBuilder write(ByteBuffer buffer) {
            this.requestBody.add(buffer);
            return this;
        }

        public RequestBuilder output(Action1<HTTPOutputStream> output) {
            this.output = output;
            return this;
        }

        public RequestBuilder output(Promise<HTTPOutputStream> promise) {
            this.promise = promise;
            return this;
        }

        public RequestBuilder headerComplete(Action1<MetaData.Response> headerComplete) {
            this.headerComplete = headerComplete;
            return this;
        }

        public RequestBuilder messageComplete(Action1<MetaData.Response> messageComplete) {
            this.messageComplete = messageComplete;
            return this;
        }

        public RequestBuilder content(Action1<ByteBuffer> content) {
            this.content = content;
            return this;
        }

        public RequestBuilder contentComplete(Action1<MetaData.Response> contentComplete) {
            this.contentComplete = contentComplete;
            return this;
        }

        public RequestBuilder badMessage(Action3<Integer, String, MetaData.Response> badMessage) {
            this.badMessage = badMessage;
            return this;
        }

        public RequestBuilder earlyEof(Action1<MetaData.Response> earlyEof) {
            this.earlyEof = earlyEof;
            return this;
        }

        public Promise.Completable<SimpleResponse> submit() {
            this.submit((Promise.Completable<SimpleResponse>)new Promise.Completable());
            return this.future;
        }

        public void submit(Promise.Completable<SimpleResponse> future) {
            this.future = future;
            SimpleHTTPClient.this.send(this);
        }

        public void submit(final Action1<SimpleResponse> action) {
            Promise.Completable<SimpleResponse> future = new Promise.Completable<SimpleResponse>(){

                public void succeeded(SimpleResponse t) {
                    super.succeeded((Object)t);
                    action.call((Object)t);
                }

                public void failed(Throwable c) {
                    super.failed(c);
                    log.error("http request exception", c);
                }
            };
            this.submit(future);
        }

        public void end() {
            SimpleHTTPClient.this.send(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestBuilder that = (RequestBuilder)o;
            return this.port == that.port && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }
    }
}

