/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.codec.http2.encode.Generator;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.Session;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.net.Session;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.concurrent.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ClientSession
extends HTTP2Session {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public HTTP2ClientSession(Scheduler scheduler, Session endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl, int streamIdleTimeout) {
        super(scheduler, endPoint, generator, listener, flowControl, 1, streamIdleTimeout);
    }

    public static HTTP2ClientSession initSessionForUpgradingHTTP2(Scheduler scheduler, Session endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl, int initialStreamId, int streamIdleTimeout, Promise<Stream> initStream, Stream.Listener initStreamListener) {
        HTTP2ClientSession session = new HTTP2ClientSession(scheduler, endPoint, generator, listener, flowControl, initialStreamId, streamIdleTimeout);
        StreamSPI stream = session.createLocalStream(1, initStream);
        stream.setListener(initStreamListener);
        stream.updateClose(true, true);
        initStream.succeeded((Object)stream);
        return session;
    }

    private HTTP2ClientSession(Scheduler scheduler, Session endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl, int initialStreamId, int streamIdleTimeout) {
        super(scheduler, endPoint, generator, listener, flowControl, initialStreamId, streamIdleTimeout);
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        int streamId;
        StreamSPI stream;
        if (log.isDebugEnabled()) {
            log.debug("Received {}", (Object)frame);
        }
        if ((stream = this.getStream(streamId = frame.getStreamId())) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring {}, stream #{} not found", (Object)frame, (Object)streamId);
            }
        } else {
            stream.process(frame, Callback.NOOP);
            this.notifyHeaders(stream, frame);
        }
    }

    private void notifyHeaders(StreamSPI stream, HeadersFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onHeaders(stream, frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)listener);
        }
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        if (log.isDebugEnabled()) {
            log.debug("Received {}", (Object)frame);
        }
        int streamId = frame.getStreamId();
        int pushStreamId = frame.getPromisedStreamId();
        StreamSPI stream = this.getStream(streamId);
        if (stream == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring {}, stream #{} not found", (Object)frame, (Object)streamId);
            }
        } else {
            StreamSPI pushStream = this.createRemoteStream(pushStreamId);
            pushStream.process(frame, Callback.NOOP);
            Stream.Listener listener = this.notifyPush(stream, pushStream, frame);
            pushStream.setListener(listener);
        }
    }

    private Stream.Listener notifyPush(StreamSPI stream, StreamSPI pushStream, PushPromiseFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return null;
        }
        try {
            return listener.onPush(pushStream, frame);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)listener);
            return null;
        }
    }
}

