/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientHTTPHandler;
import com.firefly.client.http2.HTTPClientConnection;
import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.AbstractHTTP2OutputStream;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ClientResponseHandler
extends Stream.Listener.Adapter {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final MetaData.Request request;
    private final ClientHTTPHandler handler;
    private final HTTPClientConnection connection;

    public HTTP2ClientResponseHandler(MetaData.Request request, ClientHTTPHandler handler, HTTPClientConnection connection) {
        this.request = request;
        this.handler = handler;
        this.connection = connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onHeaders(Stream stream, HeadersFrame headersFrame) {
        if (headersFrame.getMetaData() == null) {
            throw new IllegalArgumentException("the stream " + stream.getId() + " received a null meta data");
        }
        if (headersFrame.getMetaData().isResponse()) {
            HTTPOutputStream output = (HTTPOutputStream)stream.getAttribute("outputStream");
            MetaData.Response response = (MetaData.Response)headersFrame.getMetaData();
            if (response.getStatus() == 100) {
                this.handler.continueToSendData(this.request, response, output, this.connection);
                return;
            } else {
                stream.setAttribute("response", response);
                this.handler.headerComplete(this.request, response, output, this.connection);
                if (!headersFrame.isEndStream()) return;
                this.handler.messageComplete(this.request, response, output, this.connection);
            }
            return;
        } else {
            if (!headersFrame.isEndStream()) throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
            HTTPOutputStream output = (HTTPOutputStream)stream.getAttribute("outputStream");
            MetaData.Response response = (MetaData.Response)stream.getAttribute("response");
            String trailerName = response.getFields().get(HttpHeader.TRAILER);
            if (!VerifyUtils.isNotEmpty((String)trailerName)) throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
            if (!headersFrame.getMetaData().getFields().containsKey(trailerName)) throw new IllegalArgumentException("the stream " + stream.getId() + " received illegal meta data");
            response.getFields().add(trailerName, headersFrame.getMetaData().getFields().get(trailerName));
            this.handler.messageComplete(this.request, response, output, this.connection);
        }
    }

    @Override
    public void onData(Stream stream, DataFrame dataFrame, Callback callback) {
        HTTPOutputStream output = (HTTPOutputStream)stream.getAttribute("outputStream");
        MetaData.Response response = (MetaData.Response)stream.getAttribute("response");
        try {
            this.handler.content(dataFrame.getData(), this.request, response, output, this.connection);
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        if (dataFrame.isEndStream()) {
            this.handler.contentComplete(this.request, response, output, this.connection);
            this.handler.messageComplete(this.request, response, output, this.connection);
        }
    }

    @Override
    public void onReset(Stream stream, ResetFrame frame) {
        HTTPOutputStream output = (HTTPOutputStream)stream.getAttribute("outputStream");
        MetaData.Response response = (MetaData.Response)stream.getAttribute("response");
        ErrorCode errorCode = ErrorCode.from(frame.getError());
        String reason = errorCode == null ? "error=" + frame.getError() : errorCode.name().toLowerCase();
        int status = 500;
        if (errorCode != null) {
            switch (errorCode) {
                case PROTOCOL_ERROR: {
                    status = 400;
                    break;
                }
                default: {
                    status = 500;
                }
            }
        }
        this.handler.badMessage(status, reason, this.request, response, output, this.connection);
    }

    public static class ClientStreamPromise
    implements Promise<Stream> {
        private final MetaData.Request request;
        private final Promise<HTTPOutputStream> promise;
        private final boolean endStream;

        public ClientStreamPromise(MetaData.Request request, Promise<HTTPOutputStream> promise, boolean endStream) {
            this.request = request;
            this.promise = promise;
            this.endStream = endStream;
        }

        public void succeeded(Stream stream) {
            if (log.isDebugEnabled()) {
                log.debug("create a new stream {}", (Object)stream.getId());
            }
            ClientHttp2OutputStream output = new ClientHttp2OutputStream(this.request, this.endStream, stream);
            stream.setAttribute("outputStream", output);
            this.promise.succeeded((Object)output);
        }

        public void failed(Throwable x) {
            this.promise.failed(x);
            log.error("client creates stream unsuccessfully", x);
        }
    }

    public static class ClientHttp2OutputStream
    extends AbstractHTTP2OutputStream {
        private final Stream stream;

        public ClientHttp2OutputStream(MetaData info, boolean endStream, Stream stream) {
            super(info, true);
            this.commited = true;
            this.stream = stream;
            if (endStream) {
                this.isChunked = false;
            } else if (info.getFields().contains(HttpHeader.CONTENT_LENGTH)) {
                if (log.isDebugEnabled()) {
                    log.debug("stream {} commits header that contains content length {}", (Object)this.getStream().getId(), (Object)info.getFields().get(HttpHeader.CONTENT_LENGTH));
                }
                this.isChunked = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("stream {} commits header using chunked encoding", (Object)this.getStream().getId());
                }
                this.isChunked = true;
            }
        }

        @Override
        protected Stream getStream() {
            return this.stream;
        }
    }
}

