/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.HTTP1ClientConnection;
import com.firefly.client.http2.HTTP2ClientConnection;
import com.firefly.client.http2.HTTP2ClientContext;
import com.firefly.codec.http2.stream.AbstractHTTPHandler;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import java.util.Map;

public class HTTP2ClientHandler
extends AbstractHTTPHandler {
    private final Map<Integer, HTTP2ClientContext> http2ClientContext;

    public HTTP2ClientHandler(HTTP2Configuration config, Map<Integer, HTTP2ClientContext> http2ClientContext) {
        super(config);
        this.http2ClientContext = http2ClientContext;
    }

    public void sessionOpened(Session session) throws Throwable {
        HTTP2ClientContext context = this.http2ClientContext.get(session.getSessionId());
        if (context == null) {
            log.error("http2 client can not get the client context of session {}", (Object)session.getSessionId());
            session.closeNow();
            return;
        }
        if (this.config.isSecureConnectionEnabled()) {
            session.attachObject((Object)new SSLSession(this.config.getSslContextFactory(), true, session, sslSession -> {
                log.debug("client session {} SSL handshake finished", (Object)session.getSessionId());
                if ("http/1.1".equals(sslSession.applicationProtocol())) {
                    this.initializeHTTP1ClientConnection(session, context, sslSession);
                } else {
                    this.initializeHTTP2ClientConnection(session, context, sslSession);
                }
            }));
        } else {
            this.initializeHTTP1ClientConnection(session, context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHTTP1ClientConnection(Session session, HTTP2ClientContext context, SSLSession sslSession) {
        try {
            HTTP1ClientConnection http1ClientConnection = new HTTP1ClientConnection(this.config, session, sslSession);
            session.attachObject((Object)http1ClientConnection);
            context.promise.succeeded((Object)http1ClientConnection);
        }
        catch (Throwable t) {
            context.promise.failed(t);
        }
        finally {
            this.http2ClientContext.remove(session.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHTTP2ClientConnection(Session session, HTTP2ClientContext context, SSLSession sslSession) {
        try {
            HTTP2ClientConnection connection = new HTTP2ClientConnection(this.config, session, sslSession, context.listener);
            session.attachObject((Object)connection);
            connection.initialize(this.config, context.promise, context.listener);
        }
        finally {
            this.http2ClientContext.remove(session.getSessionId());
        }
    }

    @Override
    public void sessionClosed(Session session) throws Throwable {
        try {
            super.sessionClosed(session);
        }
        finally {
            this.http2ClientContext.remove(session.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedOpeningSession(Integer sessionId, Throwable t) throws Throwable {
        try {
            HTTP2ClientContext context = this.http2ClientContext.get(sessionId);
            if (context != null) {
                context.promise.failed(t);
            }
        }
        finally {
            this.http2ClientContext.remove(sessionId);
        }
    }

    @Override
    public void exceptionCaught(Session session, Throwable t) throws Throwable {
        try {
            super.exceptionCaught(session, t);
        }
        finally {
            this.http2ClientContext.remove(session.getSessionId());
        }
    }
}

