/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientHTTPHandler;
import com.firefly.client.http2.HTTP2ClientResponseHandler;
import com.firefly.client.http2.HTTP2ClientSession;
import com.firefly.client.http2.HTTPClientConnection;
import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.encode.Generator;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PrefaceFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpHeaderValue;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.AbstractHTTP2Connection;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.codec.http2.stream.Session;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.FuturePromise;
import com.firefly.utils.concurrent.Promise;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ClientConnection
extends AbstractHTTP2Connection
implements HTTPClientConnection {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public void initialize(HTTP2Configuration config, final Promise<HTTPClientConnection> promise, Session.Listener listener) {
        Map<Integer, Integer> settings = listener.onPreface(this.getHttp2Session());
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        PrefaceFrame prefaceFrame = new PrefaceFrame();
        SettingsFrame settingsFrame = new SettingsFrame(settings, false);
        SessionSPI sessionSPI = this.getSessionSPI();
        int windowDelta = config.getInitialSessionRecvWindow() - 65535;
        Callback callback = new Callback(){

            public void succeeded() {
                promise.succeeded((Object)HTTP2ClientConnection.this);
            }

            public void failed(Throwable x) {
                try {
                    HTTP2ClientConnection.this.close();
                }
                catch (IOException e) {
                    log.error("http2 client connection initialization error", (Throwable)e);
                }
                promise.failed(x);
            }
        };
        if (windowDelta > 0) {
            sessionSPI.updateRecvWindow(windowDelta);
            sessionSPI.frames(null, callback, prefaceFrame, settingsFrame, new WindowUpdateFrame(0, windowDelta));
        } else {
            sessionSPI.frames(null, callback, prefaceFrame, settingsFrame);
        }
    }

    public HTTP2ClientConnection(HTTP2Configuration config, Session tcpSession, SSLSession sslSession, Session.Listener listener) {
        super(config, tcpSession, sslSession, listener);
    }

    @Override
    protected HTTP2Session initHTTP2Session(HTTP2Configuration config, FlowControlStrategy flowControl, Session.Listener listener) {
        HTTP2ClientSession http2ClientSession = new HTTP2ClientSession(scheduler, this.tcpSession, this.generator, listener, flowControl, config.getStreamIdleTimeout());
        return http2ClientSession;
    }

    @Override
    protected Parser initParser(HTTP2Configuration config) {
        return new Parser((HTTP2ClientSession)this.http2Session, config.getMaxDynamicTableSize(), config.getMaxRequestHeadLength());
    }

    Parser getParser() {
        return this.parser;
    }

    Generator getGenerator() {
        return this.generator;
    }

    SSLSession getSSLSession() {
        return this.sslSession;
    }

    SessionSPI getSessionSPI() {
        return this.http2Session;
    }

    @Override
    public void send(MetaData.Request request, ClientHTTPHandler handler) {
        Promise<HTTPOutputStream> promise = new Promise<HTTPOutputStream>(){

            public void succeeded(HTTPOutputStream output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error("write data unsuccessfully", (Throwable)e);
                }
            }

            public void failed(Throwable x) {
                log.error("write data unsuccessfully", x);
            }
        };
        this.request(request, true, promise, handler);
    }

    @Override
    public void send(MetaData.Request request, final ByteBuffer buffer, ClientHTTPHandler handler) {
        request.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(buffer.remaining()));
        Promise<HTTPOutputStream> promise = new Promise<HTTPOutputStream>(){

            public void succeeded(HTTPOutputStream output) {
                try {
                    output.writeWithContentLength(buffer);
                }
                catch (IOException e) {
                    log.error("write data unsuccessfully", (Throwable)e);
                }
            }

            public void failed(Throwable x) {
                log.error("write data unsuccessfully", x);
            }
        };
        this.send(request, promise, handler);
    }

    @Override
    public void send(MetaData.Request request, final ByteBuffer[] buffers, ClientHTTPHandler handler) {
        long contentLength = 0L;
        for (ByteBuffer buf : buffers) {
            contentLength += (long)buf.remaining();
        }
        request.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
        Promise<HTTPOutputStream> promise = new Promise<HTTPOutputStream>(){

            public void succeeded(HTTPOutputStream output) {
                try {
                    output.writeWithContentLength(buffers);
                }
                catch (IOException e) {
                    log.error("write data unsuccessfully", (Throwable)e);
                }
            }

            public void failed(Throwable x) {
                log.error("write data unsuccessfully", x);
            }
        };
        this.send(request, promise, handler);
    }

    @Override
    public HTTPOutputStream sendRequestWithContinuation(MetaData.Request request, ClientHTTPHandler handler) {
        request.getFields().put(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE);
        return this.getHTTPOutputStream(request, handler);
    }

    @Override
    public HTTPOutputStream getHTTPOutputStream(MetaData.Request request, ClientHTTPHandler handler) {
        FuturePromise promise = new FuturePromise();
        this.send(request, (Promise<HTTPOutputStream>)promise, handler);
        try {
            return (HTTPOutputStream)promise.get();
        }
        catch (Throwable e) {
            log.error("get http output stream unsuccessfully", e);
            return null;
        }
    }

    @Override
    public void send(MetaData.Request request, Promise<HTTPOutputStream> promise, ClientHTTPHandler handler) {
        this.request(request, false, promise, handler);
    }

    public void request(MetaData.Request request, boolean endStream, Promise<HTTPOutputStream> promise, ClientHTTPHandler handler) {
        this.http2Session.newStream(new HeadersFrame(request, null, endStream), new HTTP2ClientResponseHandler.ClientStreamPromise(request, promise, endStream), new HTTP2ClientResponseHandler(request, handler, this));
    }

    @Override
    public void upgradeHTTP2(MetaData.Request request, SettingsFrame settings, Promise<HTTPClientConnection> promise, ClientHTTPHandler handler) {
        new RuntimeException("current connection version is http2, it does not need to upgrading");
    }
}

