/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientSecureDecoder;
import com.firefly.client.http2.ClientSecureEncoder;
import com.firefly.client.http2.HTTP1ClientDecoder;
import com.firefly.client.http2.HTTP1ClientEncoder;
import com.firefly.client.http2.HTTP2ClientContext;
import com.firefly.client.http2.HTTP2ClientDecoder;
import com.firefly.client.http2.HTTP2ClientEncoder;
import com.firefly.client.http2.HTTP2ClientHandler;
import com.firefly.client.http2.HTTPClientConnection;
import com.firefly.codec.http2.stream.AbstractHTTP2Connection;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.codec.http2.stream.Session;
import com.firefly.net.Client;
import com.firefly.net.Decoder;
import com.firefly.net.DecoderChain;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.tcp.aio.AsynchronousTcpClient;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.time.Millisecond100Clock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HTTP2Client
extends AbstractLifeCycle {
    private final Client client;
    private final Map<Integer, HTTP2ClientContext> http2ClientContext = new ConcurrentHashMap<Integer, HTTP2ClientContext>();
    private final AtomicInteger sessionId = new AtomicInteger(0);
    private final HTTP2Configuration http2Configuration;

    public HTTP2Client(HTTP2Configuration http2Configuration) {
        HTTP1ClientEncoder encoder;
        DecoderChain decoder;
        if (http2Configuration == null) {
            throw new IllegalArgumentException("the http2 configuration is null");
        }
        if (http2Configuration.isSecureConnectionEnabled()) {
            decoder = new ClientSecureDecoder(new HTTP1ClientDecoder(new HTTP2ClientDecoder()));
            encoder = new HTTP1ClientEncoder(new HTTP2ClientEncoder(new ClientSecureEncoder()));
        } else {
            decoder = new HTTP1ClientDecoder(new HTTP2ClientDecoder());
            encoder = new HTTP1ClientEncoder(new HTTP2ClientEncoder());
        }
        http2Configuration.getTcpConfiguration().setDecoder((Decoder)decoder);
        http2Configuration.getTcpConfiguration().setEncoder((Encoder)encoder);
        http2Configuration.getTcpConfiguration().setHandler((Handler)new HTTP2ClientHandler(http2Configuration, this.http2ClientContext));
        this.client = new AsynchronousTcpClient(http2Configuration.getTcpConfiguration());
        this.http2Configuration = http2Configuration;
    }

    public Promise.Completable<HTTPClientConnection> connect(String host, int port) {
        Promise.Completable completable = new Promise.Completable();
        this.connect(host, port, (Promise<HTTPClientConnection>)completable);
        return completable;
    }

    public void connect(String host, int port, Promise<HTTPClientConnection> promise) {
        this.connect(host, port, promise, new Session.Listener.Adapter());
    }

    public void connect(String host, int port, Promise<HTTPClientConnection> promise, Session.Listener listener) {
        this.start();
        HTTP2ClientContext context = new HTTP2ClientContext();
        context.promise = promise;
        context.listener = listener;
        int id = this.sessionId.getAndIncrement();
        this.http2ClientContext.put(id, context);
        this.client.connect(host, port, id);
    }

    public HTTP2Configuration getHttp2Configuration() {
        return this.http2Configuration;
    }

    protected void init() {
    }

    protected void destroy() {
        if (this.client != null) {
            this.client.stop();
        }
        AbstractHTTP2Connection.stopScheduler();
        LogFactory.getInstance().stop();
        Millisecond100Clock.stop();
    }
}

