/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientHTTPHandler;
import com.firefly.client.http2.HTTP1ClientConnection;
import com.firefly.client.http2.HTTPClientResponse;
import com.firefly.codec.http2.decode.HttpParser;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP1ClientResponseHandler
implements HttpParser.ResponseHandler {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected HTTP1ClientConnection connection;
    protected MetaData.Response response;
    protected MetaData.Request request;
    protected HTTPOutputStream outputStream;
    protected final ClientHTTPHandler clientHTTPHandler;

    HTTP1ClientResponseHandler(ClientHTTPHandler clientHTTPHandler) {
        this.clientHTTPHandler = clientHTTPHandler;
    }

    @Override
    public final boolean startResponse(HttpVersion version, int status, String reason) {
        if (log.isDebugEnabled()) {
            log.debug("client received the response line, {}, {}, {}", new Object[]{version, status, reason});
        }
        if (status == 100 && "Continue".equalsIgnoreCase(reason)) {
            this.clientHTTPHandler.continueToSendData(this.request, this.response, this.outputStream, this.connection);
            if (log.isDebugEnabled()) {
                log.debug("client received 100 continue, current parser state is {}", (Object)this.connection.getParser().getState());
            }
            return true;
        }
        this.response = new HTTPClientResponse(version, status, reason);
        return false;
    }

    @Override
    public final void parsedHeader(HttpField field) {
        this.response.getFields().add(field);
    }

    @Override
    public final int getHeaderCacheSize() {
        return 1024;
    }

    @Override
    public final boolean headerComplete() {
        return this.clientHTTPHandler.headerComplete(this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public final boolean content(ByteBuffer item) {
        return this.clientHTTPHandler.content(item, this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public boolean contentComplete() {
        return this.clientHTTPHandler.contentComplete(this.request, this.response, this.outputStream, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean http1MessageComplete() {
        try {
            boolean bl = this.clientHTTPHandler.messageComplete(this.request, this.response, this.outputStream, this.connection);
            return bl;
        }
        finally {
            String requestConnectionValue = this.request.getFields().get(HttpHeader.CONNECTION);
            String responseConnectionValue = this.response.getFields().get(HttpHeader.CONNECTION);
            this.connection.getParser().reset();
            switch (this.response.getHttpVersion()) {
                case HTTP_1_0: {
                    if ("keep-alive".equalsIgnoreCase(requestConnectionValue) && "keep-alive".equalsIgnoreCase(responseConnectionValue)) {
                        log.debug("the client {} connection is persistent", (Object)this.response.getHttpVersion());
                        break;
                    }
                    try {
                        this.connection.close();
                    }
                    catch (IOException e) {
                        log.error("client closes connection exception", (Throwable)e);
                    }
                    break;
                }
                case HTTP_1_1: {
                    if ("close".equalsIgnoreCase(requestConnectionValue) || "close".equalsIgnoreCase(responseConnectionValue)) {
                        try {
                            this.connection.close();
                        }
                        catch (IOException e) {
                            log.error("client closes connection exception", (Throwable)e);
                        }
                        break;
                    }
                    log.debug("the client {} connection is persistent", (Object)this.response.getHttpVersion());
                    break;
                }
                default: {
                    throw new IllegalStateException("client response does not support the http version " + (Object)((Object)this.connection.getHttpVersion()));
                }
            }
        }
    }

    @Override
    public final boolean messageComplete() {
        boolean success = this.connection.upgradeProtocolToHTTP2(this.request, this.response);
        if (success) {
            log.debug("client upgraded http2 successfully");
        }
        return this.http1MessageComplete();
    }

    @Override
    public final void badMessage(int status, String reason) {
        this.clientHTTPHandler.badMessage(status, reason, this.request, this.response, this.outputStream, this.connection);
    }

    @Override
    public void earlyEOF() {
        this.clientHTTPHandler.earlyEOF(this.request, this.response, this.outputStream, this.connection);
    }
}

