/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.EncoderChain;
import com.firefly.net.Session;
import com.firefly.utils.concurrent.Callback;
import java.nio.ByteBuffer;

public class HTTP1ClientEncoder
extends EncoderChain {
    public HTTP1ClientEncoder(EncoderChain next) {
        super(next);
    }

    public void encode(Object message, Session session) throws Throwable {
        HTTPConnection connection = (HTTPConnection)session.getAttachment();
        switch (connection.getHttpVersion()) {
            case HTTP_2: {
                this.next.encode(message, session);
                break;
            }
            case HTTP_1_1: {
                if (connection.isEncrypted()) {
                    this.next.encode(message, session);
                    break;
                }
                if (message instanceof ByteBuffer) {
                    session.write((ByteBuffer)message, Callback.NOOP);
                    break;
                }
                throw new IllegalArgumentException("the http1 encoder must receive the ByteBuffer, but this message type is " + message.getClass());
            }
            default: {
                throw new IllegalArgumentException("client does not support the http version " + (Object)((Object)connection.getHttpVersion()));
            }
        }
    }
}

