/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.HTTP1ClientConnection;
import com.firefly.codec.http2.decode.HttpParser;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.DecoderChain;
import com.firefly.net.Session;
import java.nio.ByteBuffer;

public class HTTP1ClientDecoder
extends DecoderChain {
    public HTTP1ClientDecoder(DecoderChain next) {
        super(next);
    }

    public void decode(ByteBuffer buf, Session session) throws Throwable {
        HTTPConnection connection = (HTTPConnection)session.getAttachment();
        switch (connection.getHttpVersion()) {
            case HTTP_2: {
                this.next.decode(buf, session);
                break;
            }
            case HTTP_1_1: {
                HTTP1ClientConnection http1Connection = (HTTP1ClientConnection)connection;
                HttpParser parser = http1Connection.getParser();
                while (buf.hasRemaining()) {
                    parser.parseNext(buf);
                }
                break;
            }
            default: {
                throw new IllegalStateException("client does not support the http version " + (Object)((Object)connection.getHttpVersion()));
            }
        }
    }
}

