/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.ClientHTTPHandler;
import com.firefly.client.http2.HTTP1ClientResponseHandler;
import com.firefly.client.http2.HTTP2ClientConnection;
import com.firefly.client.http2.HTTP2ClientResponseHandler;
import com.firefly.client.http2.HTTP2ClientSession;
import com.firefly.client.http2.HTTPClientConnection;
import com.firefly.codec.http2.decode.HttpParser;
import com.firefly.codec.http2.encode.HttpGenerator;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpHeaderValue;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.AbstractHTTP1Connection;
import com.firefly.codec.http2.stream.AbstractHTTP1OutputStream;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.codec.http2.stream.Session;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.codec.Base64Utils;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP1ClientConnection
extends AbstractHTTP1Connection
implements HTTPClientConnection {
    private static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Promise<HTTPClientConnection> http2ConnectionPromise;
    private Session.Listener http2SessionListener;
    private Promise<Stream> initStream;
    private Stream.Listener initStreamListener;
    private volatile boolean upgradeHTTP2Successfully = false;
    private final ResponseHandlerWrap wrap;

    public HTTP1ClientConnection(HTTP2Configuration config, Session tcpSession, SSLSession sslSession) {
        this(config, sslSession, tcpSession, new ResponseHandlerWrap());
    }

    private HTTP1ClientConnection(HTTP2Configuration config, SSLSession sslSession, Session tcpSession, HttpParser.ResponseHandler responseHandler) {
        super(config, sslSession, tcpSession, null, responseHandler);
        this.wrap = (ResponseHandlerWrap)responseHandler;
        this.wrap.connection = this;
    }

    @Override
    protected HttpParser initHttpParser(HTTP2Configuration config, HttpParser.RequestHandler requestHandler, HttpParser.ResponseHandler responseHandler) {
        return new HttpParser(responseHandler, config.getMaxRequestHeadLength());
    }

    @Override
    protected HttpGenerator initHttpGenerator() {
        return new HttpGenerator();
    }

    HttpParser getParser() {
        return this.parser;
    }

    HttpGenerator getGenerator() {
        return this.generator;
    }

    SSLSession getSSLSession() {
        return this.sslSession;
    }

    HTTP2Configuration getHTTP2Configuration() {
        return this.config;
    }

    Session getTcpSession() {
        return this.tcpSession;
    }

    boolean upgradeProtocolToHTTP2(MetaData.Request request, MetaData.Response response) {
        if (this.http2ConnectionPromise != null && this.http2SessionListener != null) {
            String upgradeValue = response.getFields().get(HttpHeader.UPGRADE);
            if (response.getStatus() == 101 && "h2c".equalsIgnoreCase(upgradeValue)) {
                this.upgradeHTTP2Successfully = true;
                HTTP2ClientConnection http2Connection = new HTTP2ClientConnection(this.getHTTP2Configuration(), this.getTcpSession(), null, this.http2SessionListener){

                    @Override
                    protected HTTP2Session initHTTP2Session(HTTP2Configuration config, FlowControlStrategy flowControl, Session.Listener listener) {
                        return HTTP2ClientSession.initSessionForUpgradingHTTP2(scheduler, this.tcpSession, this.generator, listener, flowControl, 3, config.getStreamIdleTimeout(), (Promise<Stream>)HTTP1ClientConnection.this.initStream, HTTP1ClientConnection.this.initStreamListener);
                    }
                };
                this.getTcpSession().attachObject((Object)http2Connection);
                http2Connection.initialize(this.getHTTP2Configuration(), this.http2ConnectionPromise, this.http2SessionListener);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void upgradeHTTP2(MetaData.Request request, final SettingsFrame settings, Promise<HTTPClientConnection> promise, ClientHTTPHandler handler) {
        this.upgradeHTTP2WithCleartext(request, settings, promise, new HTTP2ClientResponseHandler.ClientStreamPromise(request, (Promise<HTTPOutputStream>)new Promise.Adapter(), true), new HTTP2ClientResponseHandler(request, handler, this), new Session.Listener.Adapter(){

            @Override
            public Map<Integer, Integer> onPreface(com.firefly.codec.http2.stream.Session session) {
                return settings.getSettings();
            }

            @Override
            public void onFailure(com.firefly.codec.http2.stream.Session session, Throwable failure) {
                log.error("client failure, {}", (Object)failure, (Object)session);
            }
        }, handler);
    }

    public void upgradeHTTP2WithCleartext(MetaData.Request request, SettingsFrame settings, Promise<HTTPClientConnection> promise, Promise<Stream> initStream, Stream.Listener initStreamListener, Session.Listener listener, ClientHTTPHandler handler) {
        if (this.isEncrypted()) {
            throw new IllegalStateException("The TLS TCP connection must use ALPN to upgrade HTTP2");
        }
        this.http2ConnectionPromise = promise;
        this.http2SessionListener = listener;
        this.initStream = initStream;
        this.initStreamListener = initStreamListener;
        request.getFields().add(new HttpField(HttpHeader.CONNECTION, "Upgrade, HTTP2-Settings"));
        request.getFields().add(new HttpField(HttpHeader.UPGRADE, "h2c"));
        if (settings != null) {
            List<ByteBuffer> byteBuffers = this.http2Generator.control(settings);
            if (byteBuffers != null && byteBuffers.size() > 0) {
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    for (ByteBuffer buffer : byteBuffers) {
                        out.write(BufferUtils.toArray((ByteBuffer)buffer));
                    }
                    byte[] settingsFrame = out.toByteArray();
                    byte[] settingsPayload = new byte[settingsFrame.length - 9];
                    System.arraycopy(settingsFrame, 9, settingsPayload, 0, settingsPayload.length);
                    request.getFields().add(new HttpField(HttpHeader.HTTP2_SETTINGS, Base64Utils.encodeToUrlSafeString((byte[])settingsPayload)));
                }
                catch (IOException e) {
                    log.error("generate http2 upgrading settings exception", (Throwable)e);
                }
            } else {
                request.getFields().add(new HttpField(HttpHeader.HTTP2_SETTINGS, ""));
            }
        } else {
            request.getFields().add(new HttpField(HttpHeader.HTTP2_SETTINGS, ""));
        }
        this.send(request, handler);
    }

    @Override
    public HTTPOutputStream sendRequestWithContinuation(MetaData.Request request, ClientHTTPHandler handler) {
        request.getFields().put(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE);
        HTTPOutputStream outputStream = this.getHTTPOutputStream(request, handler);
        try {
            outputStream.commit();
        }
        catch (IOException e) {
            this.generator.reset();
            log.error("client generates the HTTP message exception", (Throwable)e);
        }
        return outputStream;
    }

    @Override
    public void send(MetaData.Request request, ClientHTTPHandler handler) {
        try (HTTPOutputStream output = this.getHTTPOutputStream(request, handler);){
            log.debug("client request and does not send data");
        }
        catch (IOException e) {
            this.generator.reset();
            log.error("client generates the HTTP message exception", (Throwable)e);
        }
    }

    @Override
    public void send(MetaData.Request request, ByteBuffer buffer, ClientHTTPHandler handler) {
        try (HTTPOutputStream output = this.getHTTPOutputStream(request, handler);){
            if (buffer != null) {
                output.writeWithContentLength(buffer);
            }
        }
        catch (IOException e) {
            this.generator.reset();
            log.error("client generates the HTTP message exception", (Throwable)e);
        }
    }

    @Override
    public void send(MetaData.Request request, ByteBuffer[] buffers, ClientHTTPHandler handler) {
        try (HTTPOutputStream output = this.getHTTPOutputStream(request, handler);){
            if (buffers != null) {
                output.writeWithContentLength(buffers);
            }
        }
        catch (IOException e) {
            this.generator.reset();
            log.error("client generates the HTTP message exception", (Throwable)e);
        }
    }

    @Override
    public HTTPOutputStream getHTTPOutputStream(MetaData.Request request, ClientHTTPHandler handler) {
        HTTP1ClientResponseHandler http1ClientResponseHandler = new HTTP1ClientResponseHandler(handler);
        this.checkWrite(request, http1ClientResponseHandler);
        http1ClientResponseHandler.outputStream = new HTTP1ClientRequestOutputStream(this, ((HTTP1ClientResponseHandler)((ResponseHandlerWrap)this.wrap).writing.get()).request);
        return http1ClientResponseHandler.outputStream;
    }

    @Override
    public void send(MetaData.Request request, Promise<HTTPOutputStream> promise, ClientHTTPHandler handler) {
        promise.succeeded((Object)this.getHTTPOutputStream(request, handler));
    }

    private void checkWrite(MetaData.Request request, HTTP1ClientResponseHandler handler) {
        if (request == null) {
            throw new IllegalArgumentException("the http client request is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("the http1 client response handler is null");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("current client session " + this.tcpSession.getSessionId() + " has been closed");
        }
        if (this.upgradeHTTP2Successfully) {
            throw new IllegalStateException("current client session " + this.tcpSession.getSessionId() + " has upgraded HTTP2");
        }
        if (!this.wrap.writing.compareAndSet(null, handler)) {
            throw new WritePendingException();
        }
        request.getFields().put(HttpHeader.HOST, this.tcpSession.getRemoteAddress().getHostString());
        handler.connection = this;
        handler.request = request;
    }

    static class HTTP1ClientRequestOutputStream
    extends AbstractHTTP1OutputStream {
        private final HTTP1ClientConnection connection;

        private HTTP1ClientRequestOutputStream(HTTP1ClientConnection connection, MetaData.Request request) {
            super(request, true);
            this.connection = connection;
        }

        @Override
        protected void generateHTTPMessageSuccessfully() {
            log.debug("client session {} generates the HTTP message completely", (Object)this.connection.tcpSession.getSessionId());
            this.connection.generator.reset();
        }

        @Override
        protected void generateHTTPMessageExceptionally(HttpGenerator.Result generatorResult, HttpGenerator.State generatorState) {
            if (log.isDebugEnabled()) {
                log.debug("http1 generator error, the result is {}, and the generator state is {}", (Object)generatorResult, (Object)generatorState);
            }
            this.connection.getGenerator().reset();
            throw new IllegalStateException("client generates http message exception.");
        }

        @Override
        protected ByteBuffer getHeaderByteBuffer() {
            return BufferUtils.allocate((int)this.connection.getHTTP2Configuration().getMaxRequestHeadLength());
        }

        @Override
        protected Session getSession() {
            return this.connection.getTcpSession();
        }

        @Override
        protected HttpGenerator getHttpGenerator() {
            return this.connection.getGenerator();
        }
    }

    private static class ResponseHandlerWrap
    implements HttpParser.ResponseHandler {
        private final AtomicReference<HTTP1ClientResponseHandler> writing = new AtomicReference();
        private int status;
        private String reason;
        private HTTP1ClientConnection connection;

        private ResponseHandlerWrap() {
        }

        @Override
        public void earlyEOF() {
            HTTP1ClientResponseHandler h = this.writing.get();
            if (h != null) {
                h.earlyEOF();
            } else {
                IO.close((Closeable)this.connection);
            }
        }

        @Override
        public void parsedHeader(HttpField field) {
            this.writing.get().parsedHeader(field);
        }

        @Override
        public boolean headerComplete() {
            return this.writing.get().headerComplete();
        }

        @Override
        public boolean content(ByteBuffer item) {
            return this.writing.get().content(item);
        }

        @Override
        public boolean contentComplete() {
            return this.writing.get().contentComplete();
        }

        @Override
        public boolean messageComplete() {
            if (this.status == 100 && "Continue".equalsIgnoreCase(this.reason)) {
                log.debug("client received the 100 Continue response");
                this.connection.getParser().reset();
                return true;
            }
            return ((HTTP1ClientResponseHandler)this.writing.getAndSet(null)).messageComplete();
        }

        @Override
        public void badMessage(int status, String reason) {
            HTTP1ClientResponseHandler h = this.writing.get();
            if (h != null) {
                h.badMessage(status, reason);
            } else {
                IO.close((Closeable)this.connection);
            }
        }

        @Override
        public int getHeaderCacheSize() {
            return 1024;
        }

        @Override
        public boolean startResponse(HttpVersion version, int status, String reason) {
            this.status = status;
            this.reason = reason;
            return this.writing.get().startResponse(version, status, reason);
        }
    }
}

