/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.client.http2;

import com.firefly.client.http2.HTTP1ClientConnection;
import com.firefly.client.http2.HTTP2ClientConnection;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.DecoderChain;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSecureDecoder
extends DecoderChain {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public ClientSecureDecoder(DecoderChain next) {
        super(next);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(ByteBuffer buf, Session session) throws Throwable {
        if (session.getAttachment() instanceof HTTPConnection) {
            ByteBuffer plaintext;
            HTTPConnection connection = (HTTPConnection)session.getAttachment();
            switch (connection.getHttpVersion()) {
                case HTTP_2: {
                    plaintext = ((HTTP2ClientConnection)connection).getSSLSession().read(buf);
                    break;
                }
                case HTTP_1_1: {
                    plaintext = ((HTTP1ClientConnection)connection).getSSLSession().read(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("client does not support the http version " + (Object)((Object)connection.getHttpVersion()));
                }
            }
            if (plaintext == null || this.next == null) return;
            this.next.decode(plaintext, session);
            return;
        } else {
            if (!(session.getAttachment() instanceof SSLSession)) return;
            SSLSession sslSession = (SSLSession)session.getAttachment();
            ByteBuffer plaintext = sslSession.read(buf);
            if (plaintext != null && plaintext.hasRemaining()) {
                log.debug("client session {} handshake finished and received cleartext size {}", (Object)session.getSessionId(), (Object)plaintext.remaining());
                if (!(session.getAttachment() instanceof HTTPConnection)) throw new IllegalStateException("the client http connection has not been created");
                if (this.next == null) return;
                this.next.decode(plaintext, session);
                return;
            } else {
                log.debug("client ssl session {} is shaking hand", (Object)session.getSessionId());
            }
        }
    }
}

