/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.support;

import com.firefly.template.exception.ExpressionError;
import com.firefly.utils.VerifyUtils;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RPNUtils {
    private static final Set<String> CONDITIONAL_OPERATOR = new HashSet<String>(Arrays.asList("==", "!=", ">", "<", ">=", "<="));
    private static final Set<String> ARITHMETIC_OR_LOGICAL_OPERATOR = new HashSet<String>(Arrays.asList("&", "|"));
    private static final Set<String> LOGICAL_OPERATOR = new HashSet<String>(Arrays.asList("&&", "||"));
    private static final Set<String> ASSIGNMENT_OPERATOR = new HashSet<String>(Arrays.asList("=", "+=", "-=", "*=", "/=", "%=", "^=", "&=", "|=", "<<=", ">>=", ">>>="));

    public static List<Fragment> getReversePolishNotation(String text) {
        String content = RPNUtils.preprocessing(text);
        StringBuilder pre = new StringBuilder();
        LinkedList<Fragment> symbolDeque = new LinkedList<Fragment>();
        LinkedList<Fragment> list = new LinkedList<Fragment>();
        block13: for (int i = 0; i < content.length(); ++i) {
            switch (content.charAt(i)) {
                case '\"': 
                case '\'': {
                    int next = content.indexOf(content.charAt(i), i + 1);
                    while (content.charAt(next - 1) == '\\') {
                        next = content.indexOf(content.charAt(i), next + 1);
                    }
                    pre.append(content.substring(i, next + 1));
                    i += next - i;
                    continue block13;
                }
                case '(': {
                    pre.delete(0, pre.length());
                    Fragment f0 = new Fragment();
                    f0.priority = -1000;
                    f0.value = "(";
                    symbolDeque.push(f0);
                    continue block13;
                }
                case '%': 
                case '*': 
                case '/': {
                    char n = content.charAt(i + 1);
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 0, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol(String.valueOf(content.charAt(i)), 10, symbolDeque, list);
                    continue block13;
                }
                case '+': 
                case '-': {
                    char n = content.charAt(i + 1);
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 0, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    if (n == content.charAt(i)) {
                        pre.append(content.charAt(i)).append(content.charAt(i + 1));
                        ++i;
                        continue block13;
                    }
                    boolean s = false;
                    String left0 = "*/%+-><=&|(^";
                    if (i == 0) {
                        s = true;
                    } else {
                        for (int j = i - 1; j >= 0; --j) {
                            char ch = content.charAt(j);
                            if (Character.isWhitespace(ch)) continue;
                            if (left0.indexOf(ch) < 0) break;
                            int _n = j - 1;
                            s = _n < 0 || (ch != '+' || content.charAt(_n) != '+') && (ch != '-' || content.charAt(_n) != '-');
                            break;
                        }
                    }
                    if (s) {
                        pre.append(content.charAt(i));
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol(String.valueOf(content.charAt(i)), 9, symbolDeque, list);
                    continue block13;
                }
                case '<': 
                case '>': {
                    char n1;
                    char c = content.charAt(i);
                    char n = content.charAt(i + 1);
                    if (c == n) {
                        if (i + 2 < content.length() && (n1 = content.charAt(i + 2)) == '=') {
                            RPNUtils.outValue(pre, list);
                            RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + content.charAt(i + 1) + "=", 0, symbolDeque, list);
                            i += 2;
                            continue block13;
                        }
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + content.charAt(i + 1), 8, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    if (i + 2 < content.length()) {
                        n1 = content.charAt(i + 2);
                        if (c == '>' && n == '>' && n1 == '>') {
                            char n2 = content.charAt(i + 3);
                            if (i + 3 < content.length() && n2 == '=') {
                                RPNUtils.outValue(pre, list);
                                RPNUtils.outSymbol(">>>=", 0, symbolDeque, list);
                                i += 3;
                                continue block13;
                            }
                            RPNUtils.outValue(pre, list);
                            RPNUtils.outSymbol(">>>", 8, symbolDeque, list);
                            i += 2;
                            continue block13;
                        }
                    }
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 7, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol(String.valueOf(content.charAt(i)), 7, symbolDeque, list);
                    continue block13;
                }
                case '=': {
                    char n = content.charAt(i + 1);
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 6, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol(String.valueOf(content.charAt(i)), 0, symbolDeque, list);
                    continue block13;
                }
                case '!': {
                    char n = content.charAt(i + 1);
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 6, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    pre.append('!');
                    continue block13;
                }
                case '&': {
                    char n = content.charAt(i + 1);
                    if (n == '&') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol("&&", 2, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol("&=", 0, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol("&", 5, symbolDeque, list);
                    continue block13;
                }
                case '|': {
                    char n = content.charAt(i + 1);
                    if (n == '|') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol("||", 1, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol("|=", 0, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol("|", 4, symbolDeque, list);
                    continue block13;
                }
                case '^': {
                    char n = content.charAt(i + 1);
                    if (n == '=') {
                        RPNUtils.outValue(pre, list);
                        RPNUtils.outSymbol(String.valueOf(content.charAt(i)) + "=", 0, symbolDeque, list);
                        ++i;
                        continue block13;
                    }
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol("^", 3, symbolDeque, list);
                    continue block13;
                }
                case ')': {
                    RPNUtils.outValue(pre, list);
                    RPNUtils.outSymbol(")", -1000, symbolDeque, list);
                    continue block13;
                }
                default: {
                    pre.append(content.charAt(i));
                }
            }
        }
        RPNUtils.outValue(pre, list);
        while (!symbolDeque.isEmpty()) {
            list.add((Fragment)symbolDeque.pop());
        }
        return list;
    }

    private static String preprocessing(String content) {
        StringBuilder ret = new StringBuilder();
        if (RPNUtils.preprocessing0(content, ret)) {
            return ret.toString();
        }
        return RPNUtils.preprocessing(ret.toString());
    }

    private static boolean preprocessing0(String content, StringBuilder ret) {
        boolean t = true;
        StringBuilder pre = new StringBuilder();
        int c = 0;
        int start = 0;
        block3: for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            switch (ch) {
                case '!': 
                case '+': 
                case '-': {
                    char c0;
                    int j;
                    boolean l = false;
                    boolean r = false;
                    String left0 = "*/%+-><=&|(^";
                    if (i == 0 || ch == '!') {
                        l = true;
                    } else {
                        for (j = i - 1; j >= 0; --j) {
                            c0 = content.charAt(j);
                            if (Character.isWhitespace(c0)) continue;
                            if (left0.indexOf(c0) < 0) break;
                            int _n = j - 1;
                            l = _n < 0 || (c0 != '+' || content.charAt(_n) != '+') && (c0 != '-' || content.charAt(_n) != '-');
                            break;
                        }
                    }
                    if (l) {
                        for (j = i + 1; j < content.length(); ++j) {
                            c0 = content.charAt(j);
                            if (Character.isWhitespace(c0)) continue;
                            if (c0 != '(') break;
                            start = j + 1;
                            r = true;
                            pre.append(c0);
                            break;
                        }
                    }
                    if (l && r) {
                        t = false;
                        ++c;
                        while (c != 0) {
                            char c02;
                            if ((c02 = content.charAt(start++)) == '(') {
                                ++c;
                            } else if (c02 == ')') {
                                --c;
                            }
                            pre.append(c02);
                        }
                        if (ch == '!') {
                            ret.append("(").append((CharSequence)pre).append(" == false) ");
                        } else {
                            ret.append("(0 ").append(ch).append(' ').append((CharSequence)pre).append(") ");
                        }
                        pre.delete(0, pre.length());
                        i = start;
                        continue block3;
                    }
                    ret.append(ch);
                    continue block3;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        return t;
    }

    private static String getSimpleValue(String v) {
        int left = 0;
        boolean n = false;
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (ch == '-') {
                n = true;
            }
            if (ch == '+' || ch == '-' || Character.isWhitespace(ch)) continue;
            left = i;
            break;
        }
        String s = v.substring(left);
        return n ? "-" + s : s;
    }

    private static boolean isString(String v) {
        char start = v.charAt(0);
        char end = v.charAt(v.length() - 1);
        return start == '\"' && end == '\"' || start == '\'' && end == '\'';
    }

    private static boolean isBoolean(String v) {
        int start = v.charAt(0) == '!' ? 1 : 0;
        return v.substring(start).trim().equals("true") || v.substring(start).trim().equals("false");
    }

    private static boolean isVariable(String v) {
        int start = v.indexOf("${");
        int end = v.indexOf(125);
        return start >= 0 && start < end;
    }

    private static void outValue(StringBuilder pre, List<Fragment> list) {
        String v = pre.toString().trim();
        if (v.length() > 0) {
            Fragment f = new Fragment();
            f.priority = -200;
            f.value = RPNUtils.getSimpleValue(v);
            if (RPNUtils.isVariable(f.value)) {
                f.type = Type.VARIABLE;
            } else if (RPNUtils.isBoolean(f.value)) {
                f.type = Type.BOOLEAN;
            } else if (RPNUtils.isString(f.value)) {
                f.type = Type.STRING;
                f.value = "\"" + f.value.substring(1, f.value.length() - 1) + "\"";
            } else if (VerifyUtils.isFloat((String)f.value)) {
                f.type = Type.FLOAT;
                char end = f.value.charAt(f.value.length() - 1);
                if (end == 'f' || end == 'F') {
                    f.value = f.value.substring(0, f.value.length() - 1);
                }
            } else if (VerifyUtils.isDouble((String)f.value)) {
                f.type = Type.DOUBLE;
            } else if (VerifyUtils.isInteger((String)f.value)) {
                f.type = Type.INTEGER;
            } else if (VerifyUtils.isLong((String)f.value)) {
                f.type = Type.LONG;
                char end = f.value.charAt(f.value.length() - 1);
                if (end == 'l' || end == 'L') {
                    f.value = f.value.substring(0, f.value.length() - 1);
                }
            } else if (f.value.equals("null")) {
                f.type = Type.NULL;
            } else {
                throw new ExpressionError("Can not determine the type: " + f.value);
            }
            list.add(f);
        }
        pre.delete(0, pre.length());
    }

    private static void outSymbol(String value, int priority, Deque<Fragment> symbolDeque, List<Fragment> list) {
        Fragment f = new Fragment();
        f.value = value;
        f.priority = priority;
        f.type = ARITHMETIC_OR_LOGICAL_OPERATOR.contains(value) ? Type.ARITHMETIC_OR_LOGICAL_OPERATOR : (LOGICAL_OPERATOR.contains(value) ? Type.LOGICAL_OPERATOR : (ASSIGNMENT_OPERATOR.contains(value) ? Type.ASSIGNMENT_OPERATOR : (CONDITIONAL_OPERATOR.contains(value) ? Type.CONDITIONAL_OPERATOR : Type.ARITHMETIC_OPERATOR)));
        if (f.value.equals(")")) {
            Fragment top = null;
            while (!symbolDeque.isEmpty()) {
                top = symbolDeque.pop();
                if (!top.value.equals("(")) {
                    list.add(top);
                    continue;
                }
                break;
            }
        } else {
            Fragment top = null;
            while (!symbolDeque.isEmpty()) {
                top = symbolDeque.peek();
                if (top.priority < f.priority) break;
                list.add(top);
                symbolDeque.pop();
            }
            symbolDeque.push(f);
        }
    }

    public static enum Type {
        VARIABLE,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        NULL,
        ARITHMETIC_OPERATOR,
        LOGICAL_OPERATOR,
        ASSIGNMENT_OPERATOR,
        ARITHMETIC_OR_LOGICAL_OPERATOR,
        CONDITIONAL_OPERATOR;

    }

    public static class Fragment {
        public int priority;
        public String value;
        public Type type;

        public String toString() {
            return this.value;
        }
    }
}

