/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.support;

import com.firefly.template.Model;
import com.firefly.template.exception.ExpressionError;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectNavigator {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    private ObjectNavigator() {
    }

    public static ObjectNavigator getInstance() {
        return Holder.instance;
    }

    public Collection<?> getCollection(Model model, String el) {
        Object ret = this.find(model, el);
        return (Collection)(ret instanceof Collection ? ret : new ArrayCollection(ret));
    }

    public Integer getInteger(Model model, String el) {
        Object ret = this.find(model, el);
        return ret != null ? ((Number)ret).intValue() : 0;
    }

    public Float getFloat(Model model, String el) {
        Object ret = this.find(model, el);
        return Float.valueOf(ret != null ? ((Number)ret).floatValue() : 0.0f);
    }

    public Long getLong(Model model, String el) {
        Object ret = this.find(model, el);
        return ret != null ? ((Number)ret).longValue() : 0L;
    }

    public Double getDouble(Model model, String el) {
        Object ret = this.find(model, el);
        return ret != null ? ((Number)ret).doubleValue() : 0.0;
    }

    public Boolean getBoolean(Model model, String el) {
        Object ret = this.find(model, el);
        return ret != null ? (Boolean)ret : false;
    }

    public String getValue(Model model, String el) {
        Object ret = this.find(model, el);
        return ret != null ? String.valueOf(ret) : "";
    }

    public Comparable<Object> getComparable(Model model, String el) {
        Object ret = this.find(model, el);
        return (Comparable)ret;
    }

    public Object find(Model model, String el) {
        Object current = null;
        String[] elements = StringUtils.split((String)el, (char)'.');
        if (elements != null && elements.length > 0) {
            current = this.getObject(model, elements[0]);
            if (current == null) {
                return null;
            }
            for (int i = 1; i < elements.length; ++i) {
                current = this.getObject(current, elements[i]);
            }
        }
        return current;
    }

    private Object getArrayObject(Object obj, int index) {
        Object ret = null;
        try {
            ret = ReflectUtils.arrayGet((Object)obj, (int)index);
        }
        catch (Throwable e) {
            log.error("get array value error", e);
        }
        return ret;
    }

    private Object getObject(Object current, String el) {
        boolean root = current instanceof Model;
        String element = el.trim();
        int listOrMapPrefixIndex = element.indexOf(91);
        if (listOrMapPrefixIndex > 0) {
            Object obj;
            int listOrMapSuffixIndex = element.indexOf(93, listOrMapPrefixIndex);
            String keyEl = element.substring(listOrMapPrefixIndex + 1, listOrMapSuffixIndex);
            String p = element.substring(0, listOrMapPrefixIndex);
            Object object = obj = root ? ((Model)current).get(p) : this.getObjectProperty(current, p);
            if (obj == null) {
                return null;
            }
            Object ret = null;
            if (this.isStringKey(keyEl)) {
                if (obj instanceof Map) {
                    ret = ((Map)obj).get(keyEl.substring(1, keyEl.length() - 1));
                }
            } else {
                int index = Integer.parseInt(keyEl);
                ret = obj instanceof List ? (Object)((List)obj).get(index) : (obj instanceof Map ? ((Map)obj).get(index) : this.getArrayObject(obj, index));
            }
            if (listOrMapSuffixIndex != element.length() - 1) {
                if (element.charAt(listOrMapSuffixIndex + 1) != '[') {
                    throw new ExpressionError("list or map expression error: " + element);
                }
                return this.getObject(ret, element.substring(listOrMapSuffixIndex + 1));
            }
            return ret;
        }
        if (listOrMapPrefixIndex < 0) {
            return root ? ((Model)current).get(element) : this.getObjectProperty(current, element);
        }
        if (listOrMapPrefixIndex == 0) {
            int listOrMapSuffixIndex = element.indexOf(93, listOrMapPrefixIndex);
            String keyEl = element.substring(listOrMapPrefixIndex + 1, listOrMapSuffixIndex);
            Object ret = null;
            if (this.isStringKey(keyEl)) {
                if (current instanceof Map) {
                    ret = ((Map)current).get(keyEl.substring(1, keyEl.length() - 1));
                }
            } else {
                int index = Integer.parseInt(keyEl);
                ret = current instanceof List ? (Object)((List)current).get(index) : (current instanceof Map ? ((Map)current).get(index) : this.getArrayObject(current, index));
            }
            if (listOrMapSuffixIndex != element.length() - 1) {
                if (element.charAt(listOrMapSuffixIndex + 1) != '[') {
                    throw new ExpressionError("list or map expression error: " + element);
                }
                return this.getObject(ret, element.substring(listOrMapSuffixIndex + 1));
            }
            return ret;
        }
        throw new ExpressionError("expression error: " + element);
    }

    private boolean isStringKey(String el) {
        char head = el.charAt(0);
        char tail = el.charAt(el.length() - 1);
        return head == '\'' && tail == '\'' || head == '\"' && tail == '\"';
    }

    private Object getObjectProperty(Object current, String propertyName) {
        Object ret = null;
        try {
            ret = ReflectUtils.get((Object)current, (String)propertyName);
        }
        catch (Throwable e) {
            log.error("get property error", e);
        }
        return ret;
    }

    private static class Holder {
        private static ObjectNavigator instance = new ObjectNavigator();

        private Holder() {
        }
    }

    private class ArrayCollection<E>
    extends AbstractCollection<E> {
        private Object obj;
        private ReflectUtils.ArrayProxy arrayProxy;
        private int size;
        private Iterator<E> iterator;

        public ArrayCollection(Object array) {
            this.obj = array;
            try {
                this.arrayProxy = ReflectUtils.getArrayProxy(array.getClass());
                this.size = this.arrayProxy.size(array);
            }
            catch (Throwable e) {
                log.error("get array proxy error", e);
            }
            this.iterator = new ArrayInterator();
        }

        @Override
        public Iterator<E> iterator() {
            return this.iterator;
        }

        @Override
        public int size() {
            return this.size;
        }

        private class ArrayInterator
        implements Iterator<E> {
            private int i = 0;

            private ArrayInterator() {
            }

            @Override
            public boolean hasNext() {
                return this.i < ArrayCollection.this.size;
            }

            @Override
            public E next() {
                return ArrayCollection.this.arrayProxy.get(ArrayCollection.this.obj, this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

