/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.parser;

import com.firefly.template.Config;
import com.firefly.template.exception.TemplateFileReadException;
import com.firefly.template.parser.JavaFileBuilder;
import com.firefly.template.parser.StateMachine;
import com.firefly.template.support.CompileUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.io.FileUtils;
import com.firefly.utils.io.LineReaderHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewFileReader {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Config config;
    private List<String> javaFiles = new ArrayList<String>();
    private List<String> templateFiles = new ArrayList<String>();
    private List<String> classNames = new ArrayList<String>();
    private List<String> javaFiles0 = new ArrayList<String>();

    public ViewFileReader(Config config) {
        this.config = config;
        if (this.init() != 0) {
            throw new TemplateFileReadException("template file parse error");
        }
    }

    private int init() {
        int ret = 0;
        File file = new File(this.config.getCompiledPath());
        if (!file.exists()) {
            file.mkdir();
        }
        this.read0(new File(this.config.getViewPath()));
        if (this.javaFiles0.size() > 0) {
            ret = CompileUtils.compile(this.config.getCompiledPath(), this.config.getClassPath(), this.config.getCharset(), this.javaFiles0);
        }
        return ret;
    }

    public List<String> getJavaFiles() {
        return this.javaFiles;
    }

    public List<String> getTemplateFiles() {
        return this.templateFiles;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    private void read0(File file) {
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    ViewFileReader.this.read0(f);
                } else if (f.getName().endsWith("." + ViewFileReader.this.config.getSuffix())) {
                    ViewFileReader.this.parse(f);
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File f) {
        String name = f.getAbsolutePath().replace('\\', '/');
        this.templateFiles.add(name.substring(this.config.getViewPath().length() - 1));
        name = name.substring(this.config.getViewPath().length() - 1, name.length() - this.config.getSuffix().length()).replace('/', '_') + "java";
        this.classNames.add(name.substring(0, name.length() - 5));
        String javaFile = this.config.getCompiledPath() + "/" + name;
        this.javaFiles.add(javaFile);
        String classFileName = javaFile.substring(0, javaFile.length() - 4) + "class";
        File classFile = new File(classFileName);
        if (classFile.exists() && classFile.lastModified() >= f.lastModified()) {
            return;
        }
        this.javaFiles0.add(javaFile);
        JavaFileBuilder javaFileBuilder = new JavaFileBuilder(this.config.getCompiledPath(), name, this.config);
        try (TemplateFileLineReaderHandler lineReaderHandler = new TemplateFileLineReaderHandler(javaFileBuilder);){
            FileUtils.read((File)f, (LineReaderHandler)lineReaderHandler, (String)this.config.getCharset());
        }
    }

    private void parseComment(String comment, JavaFileBuilder javaFileBuilder) {
        int start = comment.indexOf(35);
        int end = 0;
        if (start >= 0) {
            String content;
            String keyword;
            boolean isKey;
            for (int i = start; i < comment.length(); ++i) {
                if (comment.charAt(i) != ' ' && comment.charAt(i) != '\t' && comment.charAt(i) != '\r' && comment.charAt(i) != '\n') continue;
                end = i;
                break;
            }
            if (end <= start) {
                end = comment.length();
            }
            if (!(isKey = StateMachine.parse(keyword = comment.substring(start, end), content = comment.substring(end).trim(), javaFileBuilder))) {
                javaFileBuilder.writeText("<!--" + comment + "-->\n");
            }
        } else {
            javaFileBuilder.writeText("<!--" + comment + "-->\n");
        }
    }

    private void parseText(String text, JavaFileBuilder javaFileBuilder) {
        int end;
        int start;
        int cursor = 0;
        String t = null;
        while ((start = text.indexOf("${", cursor)) != -1 && (end = text.indexOf("}", start)) != -1) {
            String e;
            int l;
            t = text.substring(cursor, start);
            if (t.length() > 0) {
                javaFileBuilder.writeText(t);
            }
            if ((l = (e = text.substring(start + 2, end)).indexOf(40)) > 0) {
                int r = e.indexOf(41);
                if (r > l) {
                    String functionName = e.substring(0, l);
                    String[] params = StringUtils.split((String)e.substring(l + 1, r), (char)',');
                    javaFileBuilder.writeFunction(functionName, params);
                }
            } else {
                javaFileBuilder.writeObject(e);
            }
            cursor = end + 1;
        }
        if (cursor < text.length() && (t = text.substring(cursor, text.length())).length() > 0) {
            javaFileBuilder.writeText(t);
        }
    }

    private class TemplateFileLineReaderHandler
    implements LineReaderHandler,
    Closeable {
        private JavaFileBuilder javaFileBuilder;
        private StringBuilder text = new StringBuilder();
        private StringBuilder comment = new StringBuilder();
        private ParserStatus status = ParserStatus.INIT;

        public TemplateFileLineReaderHandler(JavaFileBuilder javaFileBuilder) {
            this.javaFileBuilder = javaFileBuilder;
        }

        @Override
        public void close() {
            if (this.text.length() > 0) {
                ViewFileReader.this.parseText(this.text.toString(), this.javaFileBuilder);
            }
            this.javaFileBuilder.write("\t}\n\n").writeTail().write("}");
            this.javaFileBuilder.close();
        }

        public void readline(String line, int num) {
            switch (this.status) {
                case INIT: {
                    int i = line.indexOf("<!--");
                    if (i >= 0) {
                        int j;
                        this.text.append(line.substring(0, i).trim());
                        if (this.text.length() > 0) {
                            ViewFileReader.this.parseText(this.text.toString(), this.javaFileBuilder);
                            this.text = new StringBuilder();
                        }
                        if ((j = line.indexOf("-->")) > i + 4) {
                            assert (this.comment.length() == 0);
                            ViewFileReader.this.parseComment(line.substring(i + 4, j).trim(), this.javaFileBuilder);
                            if (j + 3 >= line.length()) break;
                            this.readline(line.substring(j + 3).trim() + "\n", num);
                            break;
                        }
                        this.status = ParserStatus.COMMENT_PARSING;
                        this.comment.append(line.substring(i + 4).trim() + "\n");
                        break;
                    }
                    this.text.append(line.trim() + "\n");
                    break;
                }
                case COMMENT_PARSING: {
                    int j = line.indexOf("-->");
                    if (j >= 0) {
                        this.status = ParserStatus.INIT;
                        this.comment.append(line.substring(0, j).trim());
                        ViewFileReader.this.parseComment(this.comment.toString(), this.javaFileBuilder);
                        this.comment = new StringBuilder();
                        if (j + 3 >= line.length()) break;
                        this.readline(line.substring(j + 3).trim() + "\n", num);
                        break;
                    }
                    this.comment.append(line.trim() + "\n");
                    break;
                }
            }
        }
    }

    private static enum ParserStatus {
        INIT,
        COMMENT_PARSING;

    }
}

