/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.parser;

import com.firefly.template.exception.ExpressionError;
import com.firefly.template.parser.JavaFileBuilder;
import com.firefly.template.parser.Statement;
import com.firefly.template.support.RPNUtils;
import java.util.LinkedList;
import java.util.List;

public class StatementExpression
implements Statement {
    @Override
    public void parse(String content, JavaFileBuilder javaFileBuilder) {
        javaFileBuilder.writeStringValue(this.parse(content));
    }

    public String parse(String content) {
        List<RPNUtils.Fragment> list = RPNUtils.getReversePolishNotation(content);
        if (list.size() == 1) {
            RPNUtils.Fragment f = list.get(0);
            return f.type == RPNUtils.Type.VARIABLE ? this.getVariable(f.value, "Boolean") : f.value;
        }
        LinkedList<RPNUtils.Fragment> d = new LinkedList<RPNUtils.Fragment>();
        for (RPNUtils.Fragment f : list) {
            if (this.isSymbol(f.type)) {
                RPNUtils.Fragment right = (RPNUtils.Fragment)d.pop();
                RPNUtils.Fragment left = (RPNUtils.Fragment)d.pop();
                RPNUtils.Fragment ret = new RPNUtils.Fragment();
                switch (f.type) {
                    case ARITHMETIC_OPERATOR: {
                        if (left.type == RPNUtils.Type.STRING || right.type == RPNUtils.Type.STRING) {
                            ret.type = RPNUtils.Type.STRING;
                            if (f.value.equals("+")) {
                                ret.value = this.getStringArithmeticResult(left, right);
                                break;
                            }
                            throw new ExpressionError("The operation is not supported: " + (Object)((Object)left.type) + " " + f.value + " " + (Object)((Object)right.type));
                        }
                        if (left.type == RPNUtils.Type.DOUBLE || right.type == RPNUtils.Type.DOUBLE) {
                            ret.type = RPNUtils.Type.DOUBLE;
                            ret.value = this.getFloatArithmeticResult(left, right, f.value, false);
                            break;
                        }
                        if (left.type == RPNUtils.Type.FLOAT || right.type == RPNUtils.Type.FLOAT) {
                            ret.type = RPNUtils.Type.FLOAT;
                            ret.value = this.getFloatArithmeticResult(left, right, f.value, true);
                            break;
                        }
                        if (left.type == RPNUtils.Type.LONG || right.type == RPNUtils.Type.LONG) {
                            ret.type = RPNUtils.Type.LONG;
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, false);
                            break;
                        }
                        if (left.type == RPNUtils.Type.INTEGER || right.type == RPNUtils.Type.INTEGER) {
                            ret.type = RPNUtils.Type.INTEGER;
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, true);
                            break;
                        }
                        if (f.value.equals("+")) {
                            ret.type = RPNUtils.Type.STRING;
                            ret.value = this.getStringArithmeticResult(left, right);
                            break;
                        }
                        if (f.value.equals("/")) {
                            ret.type = RPNUtils.Type.DOUBLE;
                            ret.value = this.getFloatArithmeticResult(left, right, f.value, false);
                            break;
                        }
                        ret.type = RPNUtils.Type.LONG;
                        ret.value = this.getIntegerArithmeticResult(left, right, f.value, false);
                        break;
                    }
                    case LOGICAL_OPERATOR: {
                        ret.type = RPNUtils.Type.BOOLEAN;
                        ret.value = this.getLogicalResult(left, right, f.value);
                        if (ret.value != null) break;
                        throw new ExpressionError("The operation is not supported: " + (Object)((Object)left.type) + " " + f.value + " " + (Object)((Object)right.type));
                    }
                    case ARITHMETIC_OR_LOGICAL_OPERATOR: {
                        if (left.type == RPNUtils.Type.LONG || right.type == RPNUtils.Type.LONG) {
                            ret.type = RPNUtils.Type.LONG;
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, false);
                        } else if (left.type == RPNUtils.Type.INTEGER || right.type == RPNUtils.Type.INTEGER) {
                            ret.type = RPNUtils.Type.INTEGER;
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, true);
                        } else {
                            ret.type = RPNUtils.Type.BOOLEAN;
                            ret.value = this.getLogicalResult(left, right, f.value);
                        }
                        if (ret.value != null) break;
                        throw new ExpressionError("The operation is not supported: " + (Object)((Object)left.type) + " " + f.value + " " + (Object)((Object)right.type));
                    }
                    case CONDITIONAL_OPERATOR: {
                        ret.type = RPNUtils.Type.BOOLEAN;
                        if (f.value.equals("==") || f.value.equals("!=")) {
                            ret.value = this.getEqResult(left, right, f.value);
                            break;
                        }
                        if (left.type == RPNUtils.Type.DOUBLE || right.type == RPNUtils.Type.DOUBLE) {
                            ret.value = this.getFloatArithmeticResult(left, right, f.value, false);
                            break;
                        }
                        if (left.type == RPNUtils.Type.FLOAT || right.type == RPNUtils.Type.FLOAT) {
                            ret.value = this.getFloatArithmeticResult(left, right, f.value, true);
                            break;
                        }
                        if (left.type == RPNUtils.Type.LONG || right.type == RPNUtils.Type.LONG) {
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, false);
                            break;
                        }
                        if (left.type == RPNUtils.Type.INTEGER || right.type == RPNUtils.Type.INTEGER) {
                            ret.value = this.getIntegerArithmeticResult(left, right, f.value, true);
                            break;
                        }
                        if (left.type == RPNUtils.Type.VARIABLE && right.type == RPNUtils.Type.VARIABLE) {
                            left.value = this.getVariable(left.value, "Comparable");
                            right.value = right.type == RPNUtils.Type.VARIABLE ? this.getVariable(right.value, "Comparable") : right.value;
                            ret.value = left.value + ".compareTo(" + right.value + ") " + f.value + " 0";
                            break;
                        }
                        throw new ExpressionError((Object)((Object)left.type) + " and " + (Object)((Object)right.type) + " \u200b\u200bcan not do arithmetic.");
                    }
                    default: {
                        throw new ExpressionError("The operation is not supported: " + left.value + " " + f.value + " " + right.value);
                    }
                }
                d.push(ret);
                continue;
            }
            d.push(f);
        }
        if (d.size() != 1) {
            throw new ExpressionError("RPN error: " + content);
        }
        return ((RPNUtils.Fragment)d.pop()).value;
    }

    private boolean isSymbol(RPNUtils.Type type) {
        return type == RPNUtils.Type.ARITHMETIC_OPERATOR || type == RPNUtils.Type.LOGICAL_OPERATOR || type == RPNUtils.Type.ASSIGNMENT_OPERATOR || type == RPNUtils.Type.ARITHMETIC_OR_LOGICAL_OPERATOR || type == RPNUtils.Type.CONDITIONAL_OPERATOR;
    }

    private String getVariable(String var) {
        int start = var.indexOf("${") + 2;
        int end = var.indexOf(125);
        return "objNav.getValue(model ,\"" + var.substring(start, end) + "\")";
    }

    private String getVariable(String var, String t) {
        StringBuilder ret = new StringBuilder();
        int start = var.indexOf("${") + 2;
        int end = var.indexOf(125);
        ret.append(var.substring(0, start - 2)).append("objNav.get" + t + "(model ,\"" + var.substring(start, end) + "\")");
        if (end < var.length() - 1) {
            throw new ExpressionError("Variable format error: " + var);
        }
        return ret.toString();
    }

    private String getVariableObj(String var) {
        StringBuilder ret = new StringBuilder();
        int start = var.indexOf("${") + 2;
        int end = var.indexOf(125);
        ret.append(var.substring(0, start - 2)).append("objNav.find(model ,\"" + var.substring(start, end) + "\")");
        if (end < var.length() - 1) {
            throw new ExpressionError("Variable format error: " + var);
        }
        return ret.toString();
    }

    private String getArithmeticOrLogicalResult(RPNUtils.Fragment left, RPNUtils.Fragment right, String s, String type) {
        char f0 = s.charAt(0);
        left.value = left.type == RPNUtils.Type.VARIABLE ? this.getVariable(left.value, type) : left.value;
        right.value = right.type == RPNUtils.Type.VARIABLE ? this.getVariable(right.value, type) : right.value;
        return f0 == '*' || f0 == '/' || f0 == '%' ? left.value + " " + s + " " + right.value : "(" + left.value + " " + s + " " + right.value + ")";
    }

    private String getEqResult(RPNUtils.Fragment left, RPNUtils.Fragment right, String s) {
        boolean eq = s.equals("==");
        String ret = null;
        ret = left.type == RPNUtils.Type.VARIABLE && right.type == RPNUtils.Type.VARIABLE ? (eq ? "" : "!") + this.getVariableObj(left.value) + ".equals(" + this.getVariableObj(right.value) + ")" : (left.type == RPNUtils.Type.VARIABLE ? (right.type == RPNUtils.Type.NULL ? this.getVariableObj(left.value) + " " + s + " " + right.value : (eq ? "" : "!") + "((Object)(" + right.value + ")).equals(" + this.getVariableObj(left.value) + ")") : (right.type == RPNUtils.Type.VARIABLE ? (left.type == RPNUtils.Type.NULL ? left.value + " " + s + " " + this.getVariableObj(right.value) : (eq ? "" : "!") + "((Object)(" + left.value + ")).equals(" + this.getVariableObj(right.value) + ")") : (left.value.indexOf("objNav") >= 0 || right.value.indexOf("objNav") >= 0 ? (eq ? "" : "!") + "((Object)(" + left.value + ")).equals(" + right.value + ")" : String.valueOf(eq ? left.value.equals(right.value) : !left.value.equals(right.value)))));
        return ret;
    }

    private String getLogicalResult(RPNUtils.Fragment left, RPNUtils.Fragment right, String s) {
        String ret = null;
        ret = left.type == RPNUtils.Type.VARIABLE && right.type == RPNUtils.Type.VARIABLE ? "(" + this.getVariable(left.value, "Boolean") + " " + s + " " + this.getVariable(right.value, "Boolean") + ")" : (left.type == RPNUtils.Type.VARIABLE || right.type == RPNUtils.Type.VARIABLE ? this.getArithmeticOrLogicalResult(left, right, s, "Boolean") : (left.value.indexOf("objNav") >= 0 || right.value.indexOf("objNav") >= 0 ? left.value + " " + s + " " + right.value : String.valueOf(s.equals("&&") ? this.getBooleanValue(left.value) && this.getBooleanValue(right.value) : this.getBooleanValue(left.value) || this.getBooleanValue(right.value))));
        return ret;
    }

    private boolean getBooleanValue(String v) {
        if (v.charAt(0) == '!') {
            return new Boolean(v.substring(1).trim()) == false;
        }
        return new Boolean(v.trim());
    }

    private String getStringArithmeticResult(RPNUtils.Fragment left, RPNUtils.Fragment right) {
        left.value = left.type == RPNUtils.Type.VARIABLE ? this.getVariable(left.value) : left.value;
        String string = right.value = right.type == RPNUtils.Type.VARIABLE ? this.getVariable(right.value) : right.value;
        if (left.value.charAt(0) == '\"' && left.value.indexOf("objNav.getValue(model ,\"") < 0 && right.value.charAt(0) == '\"' && right.value.indexOf("objNav.getValue(model ,\"") < 0) {
            return "\"" + left.value.substring(1, left.value.length() - 1) + right.value.substring(1, right.value.length() - 1) + "\"";
        }
        return left.value + " + " + right.value;
    }

    private String getFloatArithmeticResult(RPNUtils.Fragment left, RPNUtils.Fragment right, String s, boolean isFloat) {
        String ret = null;
        char f0 = s.charAt(0);
        ret = left.type == RPNUtils.Type.VARIABLE || right.type == RPNUtils.Type.VARIABLE ? this.getArithmeticOrLogicalResult(left, right, s, isFloat ? "Float" : "Double") : (left.value.indexOf("objNav") >= 0 || right.value.indexOf("objNav") >= 0 ? (f0 == '*' || f0 == '/' || f0 == '%' ? left.value + " " + s + " " + right.value : "(" + left.value + " " + s + " " + right.value + ")") : this.getConstFloatArithmeticResult(left, right, s, isFloat));
        return ret;
    }

    private String getConstFloatArithmeticResult(RPNUtils.Fragment lf, RPNUtils.Fragment rf, String s, boolean isFloat) {
        float l = Float.parseFloat(lf.value);
        float r = Float.parseFloat(rf.value);
        double l0 = Double.parseDouble(lf.value);
        double r0 = Double.parseDouble(rf.value);
        String ret = null;
        char f0 = s.charAt(0);
        switch (f0) {
            case '+': {
                ret = String.valueOf(isFloat ? (double)(l + r) : l0 + r0);
                break;
            }
            case '-': {
                ret = String.valueOf(isFloat ? (double)(l - r) : l0 - r0);
                break;
            }
            case '*': {
                ret = String.valueOf(isFloat ? (double)(l * r) : l0 * r0);
                break;
            }
            case '/': {
                ret = String.valueOf(isFloat ? (double)(l / r) : l0 / r0);
                break;
            }
            case '%': {
                ret = String.valueOf(isFloat ? (double)(l % r) : l0 % r0);
                break;
            }
            case '<': {
                if (s.length() == 2 && s.charAt(1) == '=') {
                    ret = String.valueOf(isFloat ? l <= r : l0 <= r0);
                    break;
                }
                if (s.length() == 1) {
                    ret = String.valueOf(isFloat ? l < r : l0 < r0);
                    break;
                }
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
            case '>': {
                if (s.length() == 2 && s.charAt(1) == '=') {
                    ret = String.valueOf(isFloat ? l >= r : l0 >= r0);
                    break;
                }
                if (s.length() == 1) {
                    ret = String.valueOf(isFloat ? l > r : l0 > r0);
                    break;
                }
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
            default: {
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
        }
        return ret;
    }

    private String getIntegerArithmeticResult(RPNUtils.Fragment left, RPNUtils.Fragment right, String s, boolean isInteger) {
        String ret = null;
        char f0 = s.charAt(0);
        ret = left.type == RPNUtils.Type.VARIABLE || right.type == RPNUtils.Type.VARIABLE ? this.getArithmeticOrLogicalResult(left, right, s, isInteger ? "Integer" : "Long") : (left.value.indexOf("objNav") >= 0 || right.value.indexOf("objNav") >= 0 ? (f0 == '*' || f0 == '/' || f0 == '%' ? left.value + " " + s + " " + right.value : "(" + left.value + " " + s + " " + right.value + ")") : this.getConstIntegerArithmeticResult(left, right, s, isInteger));
        return ret;
    }

    private String getConstIntegerArithmeticResult(RPNUtils.Fragment lf, RPNUtils.Fragment rf, String s, boolean isInteger) {
        int l = Integer.parseInt(lf.value);
        int r = Integer.parseInt(rf.value);
        long l0 = Long.parseLong(lf.value);
        long r0 = Long.parseLong(rf.value);
        String ret = null;
        char f0 = s.charAt(0);
        switch (f0) {
            case '+': {
                ret = String.valueOf(isInteger ? (long)(l + r) : l0 + r0);
                break;
            }
            case '-': {
                ret = String.valueOf(isInteger ? (long)(l - r) : l0 - r0);
                break;
            }
            case '*': {
                ret = String.valueOf(isInteger ? (long)(l * r) : l0 * r0);
                break;
            }
            case '/': {
                ret = String.valueOf(isInteger ? (long)(l / r) : l0 / r0);
                break;
            }
            case '%': {
                ret = String.valueOf(isInteger ? (long)(l % r) : l0 % r0);
                break;
            }
            case '<': {
                if (s.length() == 2 && s.charAt(1) == '=') {
                    ret = String.valueOf(isInteger ? l <= r : l0 <= r0);
                    break;
                }
                if (s.length() == 2 && s.charAt(1) == '<') {
                    ret = String.valueOf(isInteger ? (long)(l << r) : l0 << (int)r0);
                    break;
                }
                if (s.length() == 1) {
                    ret = String.valueOf(isInteger ? l < r : l0 < r0);
                    break;
                }
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
            case '>': {
                if (s.length() == 3 && s.charAt(1) == '>' && s.charAt(2) == '>') {
                    ret = String.valueOf(isInteger ? (long)(l >>> r) : l0 >>> (int)r0);
                    break;
                }
                if (s.length() == 2 && s.charAt(1) == '>') {
                    ret = String.valueOf(isInteger ? (long)(l >> r) : l0 >> (int)r0);
                    break;
                }
                if (s.length() == 2 && s.charAt(1) == '=') {
                    ret = String.valueOf(isInteger ? l >= r : l0 >= r0);
                    break;
                }
                if (s.length() == 1) {
                    ret = String.valueOf(isInteger ? l > r : l0 > r0);
                    break;
                }
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
            case '&': {
                ret = String.valueOf(isInteger ? (long)(l & r) : l0 & r0);
                break;
            }
            case '|': {
                ret = String.valueOf(isInteger ? (long)(l | r) : l0 | r0);
                break;
            }
            case '^': {
                ret = String.valueOf(isInteger ? (long)(l ^ r) : l0 ^ r0);
                break;
            }
            default: {
                throw new ExpressionError("The operation is not supported: " + (Object)((Object)lf.type) + " " + s + " " + (Object)((Object)rf.type));
            }
        }
        return ret;
    }
}

