/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.parser;

import com.firefly.template.Config;
import com.firefly.utils.VerifyUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileBuilder {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private String name;
    private BufferedWriter writer;
    private boolean writeHead = false;
    private StringBuilder tail = new StringBuilder();
    private StringBuilder preBlank = new StringBuilder("\t\t");
    private int textCount = 0;
    private Config config;
    boolean outBreak;

    public JavaFileBuilder(String path, String name, Config config) {
        this.name = name;
        File file = new File(path, name);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), config.getCharset()));
            this.config = config;
        }
        catch (Throwable t) {
            log.error("java file builder error", t);
        }
    }

    public String getName() {
        return this.name;
    }

    public JavaFileBuilder write(String str) {
        try {
            this.writeHead();
            this.writer.write(str);
        }
        catch (Throwable t) {
            log.error("write error", t);
        }
        return this;
    }

    public StringBuilder getPreBlank() {
        return this.preBlank;
    }

    public JavaFileBuilder appendTail(String str) {
        this.tail.append(str);
        return this;
    }

    public JavaFileBuilder writeStringValue(String str) {
        this.write(this.preBlank + "out.write(String.valueOf(" + str + ").getBytes(\"" + this.config.getCharset() + "\"));\n");
        return this;
    }

    public String strEscape(String str) {
        StringBuilder sb = new StringBuilder(str.length() * 2);
        sb.append('\"');
        block9: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    continue block9;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block9;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block9;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block9;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block9;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public JavaFileBuilder writeText(String str) {
        this.write(this.preBlank + "out.write(_TEXT_" + this.textCount + ");\n").appendTail("\tprivate final byte[] _TEXT_" + this.textCount + " = str2Byte(" + this.strEscape(str) + ", \"" + this.config.getCharset() + "\");\n");
        ++this.textCount;
        return this;
    }

    public JavaFileBuilder writeObject(String el) {
        this.write(this.preBlank + "out.write(objNav.getValue(model ,\"" + el + "\").getBytes(\"" + this.config.getCharset() + "\"));\n");
        return this;
    }

    public JavaFileBuilder writeFunction(String functionName, String[] params) {
        this.write(this.preBlank + "FunctionRegistry.get(\"" + functionName + "\").render(model, out");
        for (String param : params) {
            if ((param = param.trim()).length() <= 0) continue;
            this.write(", ");
            if (VerifyUtils.isDouble((String)param) || VerifyUtils.isLong((String)param) || VerifyUtils.isFloat((String)param) || VerifyUtils.isInteger((String)param) || "null".equals(param) || "true".equals(param) || "false".equals(param)) {
                this.write(param);
                continue;
            }
            if (param.charAt(0) == '\'' && param.charAt(param.length() - 1) == '\'') {
                this.write(this.strEscape(param.substring(1, param.length() - 1)));
                continue;
            }
            if (param.charAt(0) == '\"' && param.charAt(param.length() - 1) == '\"') {
                this.write(this.strEscape(param.substring(1, param.length() - 1)));
                continue;
            }
            this.write("objNav.find(model, " + this.strEscape(param) + ")");
        }
        this.write(");\n");
        return this;
    }

    public JavaFileBuilder writeObjNav(String el) {
        this.write("objNav.getValue(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeBooleanObj(String el) {
        this.write("objNav.getBoolean(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeIntegerObj(String el) {
        this.write("objNav.getInteger(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeFloatObj(String el) {
        this.write("objNav.getFloat(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeDoubleObj(String el) {
        this.write("objNav.getDouble(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeLongObj(String el) {
        this.write("objNav.getLong(model ,\"" + el + "\")");
        return this;
    }

    public JavaFileBuilder writeTail() {
        try {
            this.writer.write(this.tail.toString());
        }
        catch (Throwable t) {
            log.error("write error", t);
        }
        return this;
    }

    private void writeHead() throws IOException {
        if (!this.writeHead) {
            this.writer.write("import java.io.OutputStream;\n");
            this.writer.write("import com.firefly.template.support.ObjectNavigator;\n");
            this.writer.write("import com.firefly.template.Model;\n");
            this.writer.write("import com.firefly.template.view.AbstractView;\n");
            this.writer.write("import com.firefly.template.TemplateFactory;\n");
            this.writer.write("import com.firefly.template.FunctionRegistry;\n\n");
            String className = this.name.substring(0, this.name.length() - 5);
            this.writer.write("public class " + className + " extends AbstractView {\n\n");
            this.writer.write("\tpublic " + className + "(TemplateFactory templateFactory){this.templateFactory = templateFactory;}\n\n");
            this.writer.write("\t@Override\n");
            this.writer.write("\tprotected void main(Model model, OutputStream out) throws Throwable {\n");
            this.writer.write("\t\tObjectNavigator objNav = ObjectNavigator.getInstance();\n");
            this.writeHead = true;
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Throwable t) {
            log.error("java file builder close error", t);
        }
    }
}

