/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template;

import com.firefly.template.Config;
import com.firefly.template.FunctionRegistry;
import com.firefly.template.View;
import com.firefly.template.function.AutoincrementFunction;
import com.firefly.template.function.CutStringFunction;
import com.firefly.template.function.DateFormatFunction;
import com.firefly.template.function.LengthFunction;
import com.firefly.template.function.ModuloOutputFunction;
import com.firefly.template.function.RemoveAttributeFunction;
import com.firefly.template.function.XmlEscapeFunction;
import com.firefly.template.parser.ViewFileReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFactory {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Config config;
    private Map<String, View> map = new HashMap<String, View>();

    public TemplateFactory() {
    }

    public TemplateFactory(File file) {
        this.config = new Config();
        this.config.setViewPath(file.getAbsolutePath());
    }

    public TemplateFactory(String path) {
        this.config = new Config();
        this.config.setViewPath(path);
    }

    public TemplateFactory(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public TemplateFactory init() {
        if (this.config == null) {
            throw new IllegalArgumentException("template config is null");
        }
        long start = System.currentTimeMillis();
        FunctionRegistry.add("dateFormat", new DateFormatFunction(this.config.getCharset()));
        FunctionRegistry.add("len", new LengthFunction(this.config.getCharset()));
        FunctionRegistry.add("increment", new AutoincrementFunction(this.config.getCharset()));
        FunctionRegistry.add("cut", new CutStringFunction(this.config.getCharset()));
        FunctionRegistry.add("escape", new XmlEscapeFunction(this.config.getCharset()));
        FunctionRegistry.add("remove", new RemoveAttributeFunction());
        FunctionRegistry.add("modOut", new ModuloOutputFunction(this.config.getCharset()));
        ViewFileReader reader = new ViewFileReader(this.config);
        List<String> javaFiles = reader.getJavaFiles();
        List<String> templateFiles = reader.getTemplateFiles();
        List<String> classNames = reader.getClassNames();
        for (int i = 0; i < javaFiles.size(); ++i) {
            String c = javaFiles.get(i);
            String classFileName = c.substring(0, c.length() - 4) + "class";
            TemplateClassLoader classLoader = new TemplateClassLoader(classFileName, TemplateFactory.class.getClassLoader());
            try {
                this.map.put(templateFiles.get(i), (View)classLoader.loadClass(classNames.get(i)).getConstructor(TemplateFactory.class).newInstance(this));
                continue;
            }
            catch (Throwable e) {
                log.error("load class error", e);
            }
        }
        long end = System.currentTimeMillis();
        log.info("template initialization spends time in {} ms", (Object)(end - start));
        return this;
    }

    public View getView(String name) {
        return this.map.get(name);
    }

    private class TemplateClassLoader
    extends ClassLoader {
        private String classFileName;

        public TemplateClassLoader(String classFileName, ClassLoader classLoader) {
            super(classLoader);
            this.classFileName = classFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findClass(String name) {
            BufferedInputStream bis = null;
            byte[] b = null;
            try {
                File file = new File(this.classFileName);
                b = new byte[(int)file.length()];
                bis = new BufferedInputStream(new FileInputStream(file));
                bis.read(b);
            }
            catch (Throwable e) {
                log.error("read class file error", e);
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        log.error("close error", (Throwable)e);
                    }
                }
            }
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

