/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.template.parser;

import com.firefly.template.parser.JavaFileBuilder;
import com.firefly.template.parser.Statement;
import com.firefly.template.parser.StatementElse;
import com.firefly.template.parser.StatementElseIf;
import com.firefly.template.parser.StatementEnd;
import com.firefly.template.parser.StatementExpression;
import com.firefly.template.parser.StatementFor;
import com.firefly.template.parser.StatementIf;
import com.firefly.template.parser.StatementInclude;
import com.firefly.template.parser.StatementSet;
import com.firefly.template.parser.StatementSwitch;
import com.firefly.template.parser.StatementSwitchCase;
import com.firefly.template.parser.StatementSwitchDefault;
import java.util.HashMap;
import java.util.Map;

public class StateMachine {
    private static final Map<String, Statement> MAP = new HashMap<String, Statement>();

    public static boolean parse(String keyword, String content, JavaFileBuilder javaFileBuilder) {
        Statement statement = MAP.get(keyword);
        if (statement == null) {
            return false;
        }
        statement.parse(content, javaFileBuilder);
        return true;
    }

    static {
        MAP.put("#eval", new StatementExpression());
        MAP.put("#if", new StatementIf());
        MAP.put("#elseif", new StatementElseIf());
        MAP.put("#else", new StatementElse());
        MAP.put("#for", new StatementFor());
        MAP.put("#switch", new StatementSwitch());
        MAP.put("#case", new StatementSwitchCase());
        MAP.put("#default", new StatementSwitchDefault());
        MAP.put("#end", new StatementEnd());
        MAP.put("#set", new StatementSet());
        MAP.put("#include", new StatementInclude());
    }
}

