/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.ssl;

import com.firefly.net.tcp.ssl.AbstractOpenSSLContextFactory;
import com.firefly.net.tcp.ssl.SecurityUtils;
import com.firefly.utils.exception.CommonRuntimeException;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;

public class SelfSignedCertificateOpenSSLContextFactory
extends AbstractOpenSSLContextFactory {
    private SelfSignedCertificate selfSignedCertificate;
    private List<String> supportedProtocols;

    public SelfSignedCertificateOpenSSLContextFactory() {
        this(Arrays.asList("h2", "http/1.1"));
    }

    public SelfSignedCertificateOpenSSLContextFactory(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        try {
            this.selfSignedCertificate = new SelfSignedCertificate("www.fireflysource.com");
        }
        catch (CertificateException e) {
            log.error("create certificate exception", (Throwable)e);
            throw new CommonRuntimeException((Throwable)e);
        }
    }

    public SelfSignedCertificate getSelfSignedCertificate() {
        return this.selfSignedCertificate;
    }

    public void setSelfSignedCertificate(SelfSignedCertificate selfSignedCertificate) {
        this.selfSignedCertificate = selfSignedCertificate;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @Override
    public SslContext createSSLContext(boolean clientMode) {
        SslContextBuilder sslContextBuilder = clientMode ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE) : SslContextBuilder.forServer((File)this.selfSignedCertificate.certificate(), (File)this.selfSignedCertificate.privateKey());
        try {
            return sslContextBuilder.ciphers(SecurityUtils.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, this.supportedProtocols)).build();
        }
        catch (SSLException e) {
            log.error("create ssl context exception", (Throwable)e);
            throw new CommonRuntimeException((Throwable)e);
        }
    }
}

