/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.ssl;

import com.firefly.net.BufferPool;
import com.firefly.net.SSLContextFactory;
import com.firefly.net.SSLEventHandler;
import com.firefly.net.Session;
import com.firefly.net.buffer.FileRegion;
import com.firefly.net.buffer.ThreadSafeIOBufferPool;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.CountingCallback;
import com.firefly.utils.io.BufferReaderHandler;
import com.firefly.utils.io.BufferUtils;
import io.netty.handler.ssl.SslHandler;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSession
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static final BufferPool bufferPool = new ThreadSafeIOBufferPool();
    private final Session session;
    private final SSLEngine sslEngine;
    private ByteBuffer inNetBuffer;
    private ByteBuffer outAppBuffer;
    private static final int requestBufferSize = 8192;
    private static final int writeBufferSize = 8192;
    private static final ByteBuffer hsBuffer = ByteBuffer.allocateDirect(0);
    private boolean closed = false;
    private SSLEngineResult.HandshakeStatus initialHSStatus;
    private boolean initialHSComplete;
    private final SSLEventHandler sslEventHandler;
    private final SslHandler sslHandler;

    public SSLSession(SSLContextFactory factory, boolean clientMode, Session session, SSLEventHandler sslEventHandler) throws IOException {
        this(factory.createSSLEngine(clientMode), session, sslEventHandler);
    }

    private SSLSession(SSLEngine sslEngine, Session session, SSLEventHandler sslEventHandler) throws IOException {
        this.session = session;
        this.sslEventHandler = sslEventHandler;
        this.sslEngine = sslEngine;
        this.outAppBuffer = ByteBuffer.allocate(8192);
        this.initialHSComplete = false;
        this.sslHandler = new SslHandler(sslEngine);
        this.sslEngine.beginHandshake();
        this.initialHSStatus = sslEngine.getHandshakeStatus();
        if (sslEngine.getUseClientMode()) {
            this.doHandshakeResponse();
        }
    }

    private boolean doHandshake(ByteBuffer receiveBuffer) throws IOException {
        if (!this.session.isOpen()) {
            this.sslEngine.closeInbound();
            this.initialHSComplete = false;
            return false;
        }
        if (this.initialHSComplete) {
            return true;
        }
        switch (this.initialHSStatus) {
            case NOT_HANDSHAKING: 
            case FINISHED: {
                this.handshakeFinish();
                return this.initialHSComplete;
            }
            case NEED_UNWRAP: {
                this.doHandshakeReceive(receiveBuffer);
                if (this.initialHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.doHandshakeResponse();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)this.initialHSStatus));
            }
        }
        return this.initialHSComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandshakeReceive(ByteBuffer receiveBuffer) throws IOException {
        this.merge(receiveBuffer);
        block15: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            block16: while (true) {
                int netSize = this.sslEngine.getSession().getPacketBufferSize();
                List inNetBuffers = BufferUtils.split((ByteBuffer)this.inNetBuffer, (int)netSize);
                Iterator iterator = inNetBuffers.iterator();
                while (true) {
                    SSLEngineResult result;
                    if (!iterator.hasNext()) continue block16;
                    ByteBuffer net = (ByteBuffer)iterator.next();
                    ByteBuffer directTmpBuffer = bufferPool.acquire(net.remaining());
                    try {
                        directTmpBuffer.put(net.slice()).flip();
                        result = this.sslEngine.unwrap(directTmpBuffer, this.outAppBuffer);
                    }
                    finally {
                        bufferPool.release(directTmpBuffer);
                    }
                    int consumed = result.bytesConsumed();
                    this.inNetBuffer.position(this.inNetBuffer.position() + consumed);
                    net.position(net.position() + consumed);
                    this.initialHSStatus = result.getHandshakeStatus();
                    if (log.isDebugEnabled()) {
                        log.debug("session {} handshake receives data, init: {} | ret: {} | complete: {} ", new Object[]{this.session.getSessionId(), this.initialHSStatus, result.getStatus(), this.initialHSComplete});
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.initialHSStatus) {
                                case NEED_TASK: {
                                    this.initialHSStatus = this.doTasks();
                                    break;
                                }
                                case NOT_HANDSHAKING: 
                                case FINISHED: {
                                    this.handshakeFinish();
                                    break block15;
                                }
                            }
                            continue block15;
                        }
                        case BUFFER_UNDERFLOW: {
                            switch (this.initialHSStatus) {
                                case NOT_HANDSHAKING: 
                                case FINISHED: {
                                    this.handshakeFinish();
                                    break;
                                }
                            }
                            break block15;
                        }
                        case BUFFER_OVERFLOW: {
                            int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                            ByteBuffer b = ByteBuffer.allocate(appSize + this.outAppBuffer.position());
                            this.outAppBuffer.flip();
                            b.put(this.outAppBuffer);
                            this.outAppBuffer = b;
                            break;
                        }
                        default: {
                            throw new IOException("Received" + (Object)((Object)result.getStatus()) + "during initial handshaking");
                        }
                    }
                }
                break;
            }
        }
    }

    private void handshakeFinish() {
        log.info("session {} handshake success!", (Object)this.session.getSessionId());
        this.initialHSComplete = true;
        this.sslEventHandler.handshakeFinished(this);
    }

    private void doHandshakeResponse() throws IOException {
        block4: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result;
            ByteBuffer writeBuf = ByteBuffer.allocateDirect(this.sslEngine.getSession().getPacketBufferSize());
            block5: while (true) {
                result = this.sslEngine.wrap(hsBuffer, writeBuf);
                this.initialHSStatus = result.getHandshakeStatus();
                if (log.isDebugEnabled()) {
                    log.debug("session {} handshake response, init: {} | ret: {} | complete: {} ", new Object[]{this.session.getSessionId(), this.initialHSStatus, result.getStatus(), this.initialHSComplete});
                }
                switch (result.getStatus()) {
                    case OK: {
                        if (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.initialHSStatus = this.doTasks();
                        }
                        writeBuf.flip();
                        this.session.write(writeBuf, Callback.NOOP);
                        continue block4;
                    }
                    case BUFFER_OVERFLOW: {
                        int netSize = this.sslEngine.getSession().getPacketBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(writeBuf.position() + netSize);
                        writeBuf.flip();
                        b.put(writeBuf);
                        writeBuf = b;
                        continue block5;
                    }
                }
                break;
            }
            throw new IOException("Received " + (Object)((Object)result.getStatus()) + " during initial handshaking");
        }
    }

    private void merge(ByteBuffer now) {
        if (!now.hasRemaining()) {
            return;
        }
        if (this.inNetBuffer != null) {
            if (this.inNetBuffer.hasRemaining()) {
                ByteBuffer ret = ByteBuffer.allocate(this.inNetBuffer.remaining() + now.remaining());
                ret.put(this.inNetBuffer).put(now).flip();
                this.inNetBuffer = ret;
            } else {
                this.inNetBuffer = now;
            }
        } else {
            this.inNetBuffer = now;
        }
    }

    private ByteBuffer getOutAppBuffer() {
        this.outAppBuffer.flip();
        if (this.outAppBuffer.hasRemaining()) {
            ByteBuffer buf = ByteBuffer.allocate(this.outAppBuffer.remaining());
            buf.put(this.outAppBuffer).flip();
            this.outAppBuffer = ByteBuffer.allocate(8192);
            if (log.isDebugEnabled()) {
                log.debug("SSL session {} unwrap, app buffer -> {}", (Object)this.session.getSessionId(), (Object)buf.remaining());
            }
            return buf;
        }
        return null;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.sslEngine.closeOutbound();
            this.closed = true;
        }
    }

    public String applicationProtocol() {
        String protocol = this.sslHandler.applicationProtocol();
        log.debug("selected protocol -> {}", (Object)protocol);
        return protocol;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer read(ByteBuffer receiveBuffer) throws IOException {
        SSLEngineResult result;
        if (!this.doHandshake(receiveBuffer)) {
            return null;
        }
        if (!this.initialHSComplete) {
            throw new IllegalStateException("The initial handshake is not complete.");
        }
        if (log.isDebugEnabled()) {
            log.debug("SSL read current session {} status -> {}", (Object)this.session.getSessionId(), (Object)this.session.isOpen());
        }
        this.merge(receiveBuffer);
        if (!this.inNetBuffer.hasRemaining()) {
            return null;
        }
        int netSize = this.sslEngine.getSession().getPacketBufferSize();
        List inNetBuffers = BufferUtils.split((ByteBuffer)this.inNetBuffer, (int)netSize);
        Iterator iterator = inNetBuffers.iterator();
        if (!iterator.hasNext()) return this.getOutAppBuffer();
        ByteBuffer net = (ByteBuffer)iterator.next();
        block8: while (true) {
            if (log.isDebugEnabled()) {
                log.debug("SSL session {} unwrap, pocket -> {},  in -> {}, out -> {}, temp -> {}", new Object[]{this.session.getSessionId(), netSize, this.inNetBuffer.remaining(), this.outAppBuffer.remaining(), net.remaining()});
            }
            ByteBuffer directTmpBuffer = bufferPool.acquire(net.remaining());
            try {
                directTmpBuffer.put(net.slice()).flip();
                result = this.sslEngine.unwrap(directTmpBuffer, this.outAppBuffer);
            }
            finally {
                bufferPool.release(directTmpBuffer);
            }
            int consumed = result.bytesConsumed();
            this.inNetBuffer.position(this.inNetBuffer.position() + consumed);
            net.position(net.position() + consumed);
            if (log.isDebugEnabled()) {
                log.debug("SSL session {} unwrap, status -> {}, in -> {}, out -> {}, temp -> {}, consumed -> {}", new Object[]{this.session.getSessionId(), result.getStatus(), this.inNetBuffer.remaining(), this.outAppBuffer.remaining(), net.remaining(), consumed});
            }
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(appSize + this.outAppBuffer.position());
                    this.outAppBuffer.flip();
                    b.put(this.outAppBuffer);
                    this.outAppBuffer = b;
                    continue block8;
                }
                case BUFFER_UNDERFLOW: {
                    return this.getOutAppBuffer();
                }
                case OK: {
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.doTasks();
                    }
                    if (!this.inNetBuffer.hasRemaining()) return this.getOutAppBuffer();
                    continue block8;
                }
            }
            break;
        }
        throw new IOException("sslEngine error during data read: " + (Object)((Object)result.getStatus()));
    }

    public int write(ByteBuffer[] outputBuffers, Callback callback) throws IOException {
        int ret = 0;
        CountingCallback countingCallback = new CountingCallback(callback, outputBuffers.length);
        for (ByteBuffer outputBuffer : outputBuffers) {
            ret += this.write(outputBuffer, (Callback)countingCallback);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer outputBuffer, Callback callback) throws IOException {
        if (!this.initialHSComplete) {
            throw new IllegalStateException("The initial handshake is not complete.");
        }
        int ret = 0;
        if (!outputBuffer.hasRemaining()) {
            return ret;
        }
        int remain = outputBuffer.remaining();
        block7: while (ret < remain) {
            SSLEngineResult result;
            ByteBuffer writeBuf = ByteBuffer.allocateDirect(8192);
            block8: while (true) {
                ByteBuffer directTmpBuffer = bufferPool.acquire(outputBuffer.remaining());
                try {
                    directTmpBuffer.put(outputBuffer.slice()).flip();
                    result = this.sslEngine.wrap(directTmpBuffer, writeBuf);
                }
                finally {
                    bufferPool.release(directTmpBuffer);
                }
                ret += result.bytesConsumed();
                switch (result.getStatus()) {
                    case OK: {
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.doTasks();
                        }
                        writeBuf.flip();
                        this.session.write(writeBuf, callback);
                        continue block7;
                    }
                    case BUFFER_OVERFLOW: {
                        int netSize = this.sslEngine.getSession().getPacketBufferSize();
                        ByteBuffer b = ByteBuffer.allocateDirect(writeBuf.position() + netSize);
                        writeBuf.flip();
                        b.put(writeBuf);
                        writeBuf = b;
                        continue block8;
                    }
                }
                break;
            }
            throw new IOException("sslEngine error during data write: " + (Object)((Object)result.getStatus()));
        }
        return ret;
    }

    public long transferFileRegion(FileRegion file, Callback callback) throws Throwable {
        long ret = 0L;
        try (FileRegion fileRegion = file;){
            fileRegion.transferTo(callback, new FileBufferReaderHandler(file.getLength()));
        }
        return ret;
    }

    public boolean isHandshakeFinished() {
        return this.initialHSComplete;
    }

    private class FileBufferReaderHandler
    implements BufferReaderHandler {
        private final long len;

        private FileBufferReaderHandler(long len) {
            this.len = len;
        }

        public void readBuffer(ByteBuffer buf, CountingCallback countingCallback, long count) {
            log.debug("write file,  count: {} , lenth: {}", (Object)count, (Object)this.len);
            try {
                SSLSession.this.write(buf, (Callback)countingCallback);
            }
            catch (Throwable e) {
                log.error("ssl session writing error", e);
            }
        }
    }
}

