/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.ssl;

import com.firefly.net.SSLContextFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenSSLContextFactory
implements SSLContextFactory {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected volatile SslContext sslContext;
    protected ByteBufAllocator byteBufAllocator = PooledByteBufAllocator.DEFAULT;

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public void setByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public SSLEngine createSSLEngine(boolean clientMode) {
        return this.getSslContext(clientMode).newEngine(this.byteBufAllocator);
    }

    @Override
    public SSLEngine createSSLEngine(boolean clientMode, String peerHost, int peerPort) {
        return this.getSslContext(clientMode).newEngine(this.byteBufAllocator, peerHost, peerPort);
    }

    public SslContext getSslContext(boolean clientMode) {
        this.init(clientMode);
        return this.sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean clientMode) {
        if (this.sslContext == null) {
            AbstractOpenSSLContextFactory abstractOpenSSLContextFactory = this;
            synchronized (abstractOpenSSLContextFactory) {
                if (this.sslContext == null) {
                    this.sslContext = this.createSSLContext(clientMode);
                }
            }
        }
    }

    public abstract SslContext createSSLContext(boolean var1);
}

