/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.firefly.net.Config;
import com.firefly.net.Decoder;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.Server;
import com.firefly.net.tcp.aio.AbstractTcpLifeCycle;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;

public class AsynchronousTcpServer
extends AbstractTcpLifeCycle
implements Server {
    public AsynchronousTcpServer() {
    }

    public AsynchronousTcpServer(Config config) {
        this.config = config;
    }

    public AsynchronousTcpServer(Decoder decoder, Encoder encoder, Handler handler) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
    }

    public AsynchronousTcpServer(Decoder decoder, Encoder encoder, Handler handler, int timeout) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
        this.config.setTimeout(timeout);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public void listen(String host, int port) {
        this.start();
        this.listen(this.bind(host, port));
        log.info("start server. host: {}, port: {}", (Object)host, (Object)port);
    }

    private AsynchronousServerSocketChannel bind(String host, int port) {
        AsynchronousServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = AsynchronousServerSocketChannel.open(this.group);
            serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            serverSocketChannel.bind(new InetSocketAddress(host, port), 16384);
        }
        catch (Exception e) {
            log.error("ServerSocket bind error", (Throwable)e);
        }
        return serverSocketChannel;
    }

    private void listen(final AsynchronousServerSocketChannel serverSocketChannel) {
        serverSocketChannel.accept(this.sessionId.getAndIncrement(), new CompletionHandler<AsynchronousSocketChannel, Integer>(){

            @Override
            public void completed(AsynchronousSocketChannel socketChannel, Integer sessionId) {
                try {
                    AsynchronousTcpServer.this.worker.registerChannel(socketChannel, sessionId);
                }
                finally {
                    AsynchronousTcpServer.this.listen(serverSocketChannel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable t, Integer sessionId) {
                try {
                    try {
                        AsynchronousTcpServer.this.config.getHandler().failedAcceptingSession(sessionId, t);
                    }
                    catch (Throwable e) {
                        AbstractTcpLifeCycle.log.error("session {} accepting exception", (Object)e, (Object)sessionId);
                    }
                    AbstractTcpLifeCycle.log.error("server accepts channel {} error occurs", (Object)t, (Object)sessionId);
                }
                finally {
                    AsynchronousTcpServer.this.listen(serverSocketChannel);
                }
            }
        });
    }

    @Override
    protected String getThreadName() {
        return "firefly-aio-tcp-server-";
    }
}

