/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.codahale.metrics.Timer;
import com.firefly.net.Client;
import com.firefly.net.Config;
import com.firefly.net.Decoder;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.tcp.aio.AbstractTcpLifeCycle;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;

public class AsynchronousTcpClient
extends AbstractTcpLifeCycle
implements Client {
    public AsynchronousTcpClient() {
    }

    public AsynchronousTcpClient(Config config) {
        this.config = config;
    }

    public AsynchronousTcpClient(Decoder decoder, Encoder encoder, Handler handler) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
    }

    public AsynchronousTcpClient(Decoder decoder, Encoder encoder, Handler handler, int timeout) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
        this.config.setTimeout(timeout);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public int connect(String host, int port) {
        int id = this.sessionId.getAndIncrement();
        this.connect(host, port, id);
        return id;
    }

    @Override
    public void connect(String host, int port, int id) {
        this.start();
        try {
            Timer timer = this.config.getMetricReporterFactory().getMetricRegistry().timer("aio.AsynchronousTcpClient.connect:```" + host + ":" + port + "```");
            final Timer.Context context = timer.time();
            final AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(this.group);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)false);
            socketChannel.connect(new InetSocketAddress(host, port), id, new CompletionHandler<Void, Integer>(){

                @Override
                public void completed(Void result, Integer sessionId) {
                    AsynchronousTcpClient.this.worker.registerChannel(socketChannel, sessionId);
                    context.stop();
                }

                @Override
                public void failed(Throwable t, Integer sessionId) {
                    try {
                        AsynchronousTcpClient.this.config.getHandler().failedOpeningSession(sessionId, t);
                    }
                    catch (Throwable e) {
                        AbstractTcpLifeCycle.log.error("session {} open exception", (Object)e, (Object)sessionId);
                    }
                    AbstractTcpLifeCycle.log.error("session {} connect error", (Object)t, (Object)sessionId);
                    context.stop();
                }
            });
        }
        catch (IOException e) {
            log.error("client connect error", (Throwable)e);
        }
    }

    @Override
    protected String getThreadName() {
        return "firefly-aio-tcp-client-";
    }
}

