/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.codahale.metrics.ScheduledReporter;
import com.firefly.net.Config;
import com.firefly.net.event.DefaultEventManager;
import com.firefly.net.exception.NetException;
import com.firefly.net.tcp.aio.AsynchronousTcpWorker;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTcpLifeCycle
extends AbstractLifeCycle {
    protected static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected Config config;
    protected AtomicInteger sessionId = new AtomicInteger();
    protected AsynchronousChannelGroup group;
    protected AsynchronousTcpWorker worker;
    protected ScheduledReporter reporter;

    protected abstract String getThreadName();

    protected void init() {
        if (this.config == null) {
            throw new NetException("server configuration is null");
        }
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(new ForkJoinPool(this.config.getAsynchronousCorePoolSize(), pool -> {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName(this.getThreadName() + worker.getPoolIndex());
                return worker;
            }, null, true));
            log.info(this.config.toString());
            DefaultEventManager eventManager = new DefaultEventManager(this.config);
            this.worker = new AsynchronousTcpWorker(this.config, eventManager);
            if (this.config.isMonitorEnable()) {
                this.reporter = this.config.getMetricReporterFactory().getScheduledReporter();
                try {
                    this.reporter.start(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error("start metric reporter exception -> {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("initialization server channel group error", (Throwable)e);
        }
    }

    protected void destroy() {
        if (this.group != null) {
            try {
                this.group.shutdown();
            }
            catch (Exception e) {
                log.error("aio tcp thread group shutdown exception -> {}", (Object)e.getMessage());
            }
        }
        if (this.config.isMonitorEnable()) {
            try {
                this.reporter.stop();
            }
            catch (Exception e) {
                log.error("stop metric reporter exception -> {}", (Object)e.getMessage());
            }
        }
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        try {
            iLoggerFactory.getClass().getDeclaredMethod("stop", new Class[0]).invoke((Object)iLoggerFactory, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            System.out.println(e.getMessage());
        }
        Millisecond100Clock.stop();
    }
}

