/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Session;
import com.firefly.net.tcp.AbstractSimpleHandler;
import com.firefly.net.tcp.SecureTcpConnectionImpl;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.net.tcp.TcpConnectionImpl;
import com.firefly.net.tcp.TcpServerConfiguration;
import com.firefly.net.tcp.aio.AsynchronousTcpServer;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action2;
import com.firefly.utils.lang.AbstractLifeCycle;

public class SimpleTcpServer
extends AbstractLifeCycle {
    private Action1<TcpConnection> accept;
    private Action2<Integer, Throwable> failedAcceptance;
    private AsynchronousTcpServer server;
    private TcpServerConfiguration config;

    public SimpleTcpServer() {
        this(new TcpServerConfiguration());
    }

    public SimpleTcpServer(TcpServerConfiguration config) {
        this.config = config;
        this.server = new AsynchronousTcpServer(config);
    }

    public SimpleTcpServer accept(Action1<TcpConnection> accept) {
        this.accept = accept;
        return this;
    }

    public SimpleTcpServer accept(Action1<TcpConnection> accept, Action2<Integer, Throwable> failed) {
        this.accept = accept;
        this.failedAcceptance = failed;
        return this;
    }

    public void listen(String host, int port) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.start();
    }

    protected void init() {
        if (!this.config.isSecureConnectionEnabled()) {
            this.config.setDecoder(AbstractSimpleHandler.decoder);
            this.config.setHandler(new AbstractHandler(){

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    TcpConnectionImpl c = new TcpConnectionImpl(session);
                    session.attachObject(c);
                    if (SimpleTcpServer.this.accept != null) {
                        SimpleTcpServer.this.accept.call((Object)c);
                    }
                }
            });
        } else {
            this.config.setDecoder(AbstractSimpleHandler.sslDecoder);
            this.config.setHandler(new AbstractHandler(){

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    session.attachObject(new SecureTcpConnectionImpl(session, new SSLSession(SimpleTcpServer.this.config.getSslContextFactory(), false, session, ssl -> {
                        Object o = session.getAttachment();
                        if (o != null && o instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                            if (SimpleTcpServer.this.accept != null) {
                                SimpleTcpServer.this.accept.call((Object)c);
                            }
                        }
                    })));
                }

                @Override
                public void sessionClosed(Session session) throws Throwable {
                    super.sslSessionClosed(session);
                }
            });
        }
        this.server.listen(this.config.getHost(), this.config.getPort());
    }

    protected void destroy() {
        this.server.stop();
    }

    public abstract class AbstractHandler
    extends AbstractSimpleHandler {
        @Override
        public void failedAcceptingSession(Integer sessionId, Throwable t) throws Throwable {
            if (SimpleTcpServer.this.failedAcceptance != null) {
                SimpleTcpServer.this.failedAcceptance.call((Object)sessionId, (Object)t);
            }
        }
    }
}

