/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.buffer;

import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.io.BufferReaderHandler;
import com.firefly.utils.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class FileRegion
implements Closeable {
    private final File file;
    private final long position;
    private final long length;
    private final boolean randomAccess;
    private FileChannel fileChannel;

    public FileRegion(File file) throws FileNotFoundException {
        this.file = file;
        this.position = 0L;
        this.length = file.length();
        this.randomAccess = false;
    }

    public FileRegion(File file, long position, long length) throws FileNotFoundException {
        long fileLen = file.length();
        if (position < 0L || position >= fileLen) {
            throw new IndexOutOfBoundsException("the position range is illegal");
        }
        this.file = file;
        this.position = position;
        this.length = length;
        this.randomAccess = position > 0L ? true : length < fileLen;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        return this.length;
    }

    public FileChannel getFileChannel() throws IOException {
        if (this.fileChannel != null) {
            return this.fileChannel;
        }
        this.fileChannel = FileChannel.open(Paths.get(this.file.toURI()), StandardOpenOption.READ);
        return this.fileChannel;
    }

    public boolean isRandomAccess() {
        return this.randomAccess;
    }

    public File getFile() {
        return this.file;
    }

    public long transferTo(Callback callback, BufferReaderHandler handler) throws IOException {
        long ret = this.isRandomAccess() ? FileUtils.transferTo((FileChannel)this.getFileChannel(), (long)this.getPosition(), (long)this.getLength(), (Callback)callback, (BufferReaderHandler)handler) : FileUtils.transferTo((FileChannel)this.getFileChannel(), (long)this.getLength(), (Callback)callback, (BufferReaderHandler)handler);
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }
}

