/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.codec;

import com.firefly.net.tcp.codec.AbstractMessageHandler;
import com.firefly.net.tcp.codec.CharParser;
import com.firefly.net.tcp.codec.DelimiterParser;
import com.firefly.utils.function.Action1;
import java.nio.ByteBuffer;

public class StringParser
extends AbstractMessageHandler<ByteBuffer, String> {
    private final CharParser charParser = new CharParser();
    private final DelimiterParser delimiterParser;

    public StringParser() {
        this("\n");
    }

    public StringParser(String delimiter) {
        this.delimiterParser = new DelimiterParser(delimiter);
        this.charParser.complete(this.delimiterParser::receive);
    }

    @Override
    public void parse(ByteBuffer buffer) {
        this.charParser.receive(buffer);
    }

    public StringParser complete(Action1<String> action) {
        super.complete(action);
        this.delimiterParser.complete(action);
        return this;
    }

    public StringParser exception(Action1<Throwable> exception) {
        super.exception(exception);
        this.charParser.exception(exception);
        this.delimiterParser.exception(exception);
        return this;
    }
}

