/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.codec;

import com.firefly.net.tcp.codec.AbstractMessageHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class CharParser
extends AbstractMessageHandler<ByteBuffer, String> {
    private ByteBuffer buffer;
    private CharsetDecoder decoder;

    public CharParser() {
        this("UTF-8");
    }

    public CharParser(String charset) {
        this.decoder = Charset.forName(charset).newDecoder();
    }

    @Override
    public void parse(ByteBuffer buf) {
        try {
            this.merge(buf);
            this.parse();
        }
        catch (Throwable t) {
            this.exception.call((Object)t);
        }
    }

    private void merge(ByteBuffer buf) {
        if (this.buffer != null) {
            if (this.buffer.hasRemaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(this.buffer.remaining() + buf.remaining());
                tmp.put(this.buffer).put(buf).flip();
                this.buffer = tmp;
            } else {
                this.buffer = buf;
            }
        } else {
            this.buffer = buf;
        }
    }

    private void parse() {
        CharBuffer charBuff = this.allocate();
        while (this.buffer.hasRemaining()) {
            CoderResult r = this.decoder.decode(this.buffer, charBuff, false);
            charBuff.flip();
            if (r.isUnderflow()) {
                if (this.buffer.hasRemaining()) {
                    this.buffer = this.buffer.slice();
                }
                if (!charBuff.hasRemaining()) break;
                this.action.call((Object)charBuff.toString());
                break;
            }
            if (!r.isOverflow()) continue;
            this.action.call((Object)charBuff.toString());
            charBuff = this.allocate();
        }
    }

    private CharBuffer allocate() {
        int expectedLength = (int)((float)this.buffer.remaining() * this.decoder.averageCharsPerByte()) + 1;
        return CharBuffer.allocate(expectedLength);
    }
}

