/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.codec;

import com.firefly.net.tcp.codec.MessageHandler;
import com.firefly.utils.function.Action1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler<R, T>
implements MessageHandler<R, T> {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected Action1<T> action;
    protected Action1<Throwable> exception;

    @Override
    public void receive(R obj) {
        this.check();
        this.parse(obj);
    }

    @Override
    public MessageHandler<R, T> complete(Action1<T> action) {
        this.action = action;
        return this;
    }

    @Override
    public MessageHandler<R, T> exception(Action1<Throwable> exception) {
        this.exception = exception;
        return this;
    }

    protected abstract void parse(R var1);

    private void check() {
        if (this.action == null) {
            throw new IllegalArgumentException("the complete callback is null");
        }
        if (this.exception == null) {
            this.exception = t -> log.error("parsing exception", t);
        }
    }
}

