/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.codahale.metrics.ScheduledReporter;
import com.firefly.net.Config;
import com.firefly.net.Decoder;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.Server;
import com.firefly.net.event.DefaultEventManager;
import com.firefly.net.exception.NetException;
import com.firefly.net.tcp.aio.AsynchronousTcpWorker;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousTcpServer
extends AbstractLifeCycle
implements Server {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Config config;
    private AtomicInteger id = new AtomicInteger();
    private AsynchronousTcpWorker worker;
    private AsynchronousChannelGroup group;
    private ScheduledReporter reporter;

    public AsynchronousTcpServer() {
    }

    public AsynchronousTcpServer(Config config) {
        this.config = config;
    }

    public AsynchronousTcpServer(Decoder decoder, Encoder encoder, Handler handler) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
    }

    public AsynchronousTcpServer(Decoder decoder, Encoder encoder, Handler handler, int timeout) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
        this.config.setTimeout(timeout);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public void listen(String host, int port) {
        this.start();
        this.listen(this.bind(host, port));
        log.info("start server. host: {}, port: {}", (Object)host, (Object)port);
    }

    private AsynchronousServerSocketChannel bind(String host, int port) {
        AsynchronousServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = AsynchronousServerSocketChannel.open(this.group);
            serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            serverSocketChannel.bind(new InetSocketAddress(host, port), 16384);
        }
        catch (Exception e) {
            log.error("ServerSocket bind error", (Throwable)e);
        }
        return serverSocketChannel;
    }

    private void listen(final AsynchronousServerSocketChannel serverSocketChannel) {
        serverSocketChannel.accept(this.id.getAndIncrement(), new CompletionHandler<AsynchronousSocketChannel, Integer>(){

            @Override
            public void completed(AsynchronousSocketChannel socketChannel, Integer sessionId) {
                try {
                    AsynchronousTcpServer.this.worker.registerChannel(socketChannel, sessionId);
                }
                finally {
                    AsynchronousTcpServer.this.listen(serverSocketChannel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable t, Integer sessionId) {
                try {
                    try {
                        AsynchronousTcpServer.this.config.getHandler().failedAcceptingSession(sessionId, t);
                    }
                    catch (Throwable e) {
                        log.error("session {} accepting exception", (Object)e, (Object)sessionId);
                    }
                    log.error("server accepts channel {} error occurs", (Object)t, (Object)sessionId);
                }
                finally {
                    AsynchronousTcpServer.this.listen(serverSocketChannel);
                }
            }
        });
    }

    protected void init() {
        if (this.config == null) {
            throw new NetException("server configuration is null");
        }
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(new ThreadPoolExecutor(this.config.getAsynchronousCorePoolSize(), this.config.getAsynchronousMaximumPoolSize(), (long)this.config.getAsynchronousPoolKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), r -> new Thread(r, "firefly asynchronous server thread")));
            log.info(this.config.toString());
            DefaultEventManager eventManager = new DefaultEventManager(this.config);
            this.worker = new AsynchronousTcpWorker(this.config, eventManager);
            if (this.config.isMonitorEnable()) {
                this.reporter = (ScheduledReporter)this.config.getReporterFactory().call();
                this.reporter.start(10L, TimeUnit.SECONDS);
            }
        }
        catch (IOException e) {
            log.error("initialization server channel group error", (Throwable)e);
        }
    }

    protected void destroy() {
        if (this.group != null) {
            this.group.shutdown();
        }
        if (this.config.isMonitorEnable()) {
            this.reporter.stop();
        }
        LogFactory.getInstance().stop();
        Millisecond100Clock.stop();
    }
}

