/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.firefly.net.Client;
import com.firefly.net.Config;
import com.firefly.net.Decoder;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.net.event.DefaultEventManager;
import com.firefly.net.tcp.aio.AsynchronousTcpWorker;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousTcpClient
extends AbstractLifeCycle
implements Client {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Config config;
    private AtomicInteger sessionId = new AtomicInteger(0);
    private AsynchronousChannelGroup group;
    private AsynchronousTcpWorker worker;
    private ScheduledReporter reporter;

    public AsynchronousTcpClient() {
    }

    public AsynchronousTcpClient(Config config) {
        this.config = config;
    }

    public AsynchronousTcpClient(Decoder decoder, Encoder encoder, Handler handler) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
    }

    public AsynchronousTcpClient(Decoder decoder, Encoder encoder, Handler handler, int timeout) {
        this.config = new Config();
        this.config.setDecoder(decoder);
        this.config.setEncoder(encoder);
        this.config.setHandler(handler);
        this.config.setTimeout(timeout);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public int connect(String host, int port) {
        int id = this.sessionId.getAndIncrement();
        this.connect(host, port, id);
        return id;
    }

    @Override
    public void connect(String host, int port, int id) {
        this.start();
        try {
            Timer timer = this.config.getMetrics().timer("AsynchronousTcpClient.connect:```" + host + ":" + port + "```");
            final Timer.Context context = timer.time();
            final AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(this.group);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)false);
            socketChannel.connect(new InetSocketAddress(host, port), id, new CompletionHandler<Void, Integer>(){

                @Override
                public void completed(Void result, Integer sessionId) {
                    AsynchronousTcpClient.this.worker.registerChannel(socketChannel, sessionId);
                    context.stop();
                }

                @Override
                public void failed(Throwable t, Integer sessionId) {
                    try {
                        AsynchronousTcpClient.this.config.getHandler().failedOpeningSession(sessionId, t);
                    }
                    catch (Throwable e) {
                        log.error("session {} open exception", (Object)e, (Object)sessionId);
                    }
                    log.error("session {} connect error", (Object)t, (Object)sessionId);
                    context.stop();
                }
            });
        }
        catch (IOException e) {
            log.error("client connect error", (Throwable)e);
        }
    }

    protected void init() {
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(new ThreadPoolExecutor(this.config.getAsynchronousCorePoolSize(), this.config.getAsynchronousMaximumPoolSize(), (long)this.config.getAsynchronousPoolKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), r -> new Thread(r, "firefly asynchronous client thread")));
            log.info(this.config.toString());
            DefaultEventManager eventManager = new DefaultEventManager(this.config);
            this.worker = new AsynchronousTcpWorker(this.config, eventManager);
            if (this.config.isMonitorEnable()) {
                this.reporter = (ScheduledReporter)this.config.getReporterFactory().call();
                this.reporter.start(10L, TimeUnit.SECONDS);
            }
        }
        catch (IOException e) {
            log.error("initialization client channel group error", (Throwable)e);
        }
    }

    protected void destroy() {
        if (this.group != null) {
            this.group.shutdown();
        }
        if (this.config.isMonitorEnable()) {
            this.reporter.stop();
        }
        LogFactory.getInstance().stop();
        Millisecond100Clock.stop();
    }
}

