/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Session;
import com.firefly.net.buffer.FileRegion;
import com.firefly.net.tcp.AbstractTcpConnection;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.function.Action0;
import com.firefly.utils.function.Action1;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class TcpConnectionImpl
extends AbstractTcpConnection {
    public TcpConnectionImpl(Session session) {
        super(session);
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(String message, final Action0 succeeded, final Action1<Throwable> failed) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset, final Action0 succeeded, final Action1<Throwable> failed) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file, final Action0 succeeded, final Action1<Throwable> failed) {
        this.session.write(file, new Callback(){

            public void succeeded() {
                succeeded.call();
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer, final Action0 succeeded) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer, final Action0 succeeded) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer, final Action0 succeeded) {
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(String message, final Action0 succeeded) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset, final Action0 succeeded) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        this.session.write(byteBuffer, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file, final Action0 succeeded) {
        this.session.write(file, new Callback(){

            public void succeeded() {
                succeeded.call();
            }
        });
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer) {
        this.session.write(byteBuffer, Callback.NOOP);
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer) {
        this.session.write(byteBuffer, Callback.NOOP);
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer) {
        this.session.write(byteBuffer, Callback.NOOP);
        return this;
    }

    @Override
    public TcpConnection write(String message) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        this.session.write(byteBuffer, Callback.NOOP);
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        this.session.write(byteBuffer, Callback.NOOP);
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file) {
        this.session.write(file, Callback.NOOP);
        return this;
    }
}

