/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Session;
import com.firefly.net.tcp.AbstractSimpleHandler;
import com.firefly.net.tcp.SecureTcpConnectionImpl;
import com.firefly.net.tcp.TcpConfiguration;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.net.tcp.TcpConnectionImpl;
import com.firefly.net.tcp.aio.AsynchronousTcpClient;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.function.Action1;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleTcpClient
extends AbstractLifeCycle {
    private AsynchronousTcpClient client;
    private TcpConfiguration config;
    private Map<Integer, Promise<TcpConnection>> context = new ConcurrentHashMap<Integer, Promise<TcpConnection>>();

    public SimpleTcpClient() {
        this(new TcpConfiguration());
    }

    public SimpleTcpClient(TcpConfiguration config) {
        this.client = new AsynchronousTcpClient(config);
        this.config = config;
    }

    public Promise.Completable<TcpConnection> connect(String host, int port) {
        Promise.Completable promise = new Promise.Completable();
        this.connect(host, port, (Promise<TcpConnection>)promise);
        return promise;
    }

    public void connect(String host, int port, final Action1<TcpConnection> conn) {
        Promise<TcpConnection> promise = new Promise<TcpConnection>(){

            public void succeeded(TcpConnection result) {
                conn.call((Object)result);
            }
        };
        this.connect(host, port, promise);
    }

    public void connect(String host, int port, final Action1<TcpConnection> conn, final Action1<Throwable> failed) {
        Promise<TcpConnection> promise = new Promise<TcpConnection>(){

            public void succeeded(TcpConnection result) {
                conn.call((Object)result);
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        };
        this.connect(host, port, promise);
    }

    public void connect(String host, int port, Promise<TcpConnection> promise) {
        this.start();
        int sessionId = this.client.connect(host, port);
        this.context.put(sessionId, promise);
    }

    protected void init() {
        if (!this.config.isSecureConnectionEnabled()) {
            this.config.setDecoder(AbstractSimpleHandler.decoder);
            this.config.setHandler(new AbstractHandler(){

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    TcpConnectionImpl c = new TcpConnectionImpl(session);
                    session.attachObject(c);
                    SimpleTcpClient.this.sessionOpen(session, c);
                }
            });
        } else {
            this.config.setDecoder(AbstractSimpleHandler.sslDecoder);
            this.config.setHandler(new AbstractHandler(){

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    session.attachObject(new SecureTcpConnectionImpl(session, new SSLSession(SimpleTcpClient.this.config.getSslContextFactory(), true, session, ssl -> {
                        Object o = session.getAttachment();
                        if (o != null && o instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                            SimpleTcpClient.this.sessionOpen(session, c);
                        }
                    })));
                }

                @Override
                public void sessionClosed(Session session) throws Throwable {
                    try {
                        super.sslSessionClosed(session);
                    }
                    finally {
                        SimpleTcpClient.this.context.remove(session.getSessionId());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionOpen(Session session, TcpConnection c) {
        try {
            Promise<TcpConnection> promise = this.context.get(session.getSessionId());
            if (promise != null) {
                promise.succeeded((Object)c);
            }
        }
        finally {
            this.context.remove(session.getSessionId());
        }
    }

    protected void destroy() {
        this.client.stop();
    }

    public abstract class AbstractHandler
    extends AbstractSimpleHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedOpeningSession(Integer sessionId, Throwable t) throws Throwable {
            try {
                Promise promise = (Promise)SimpleTcpClient.this.context.get(sessionId);
                if (promise != null) {
                    promise.failed(t);
                }
            }
            finally {
                SimpleTcpClient.this.context.remove(sessionId);
            }
        }

        @Override
        public void sessionClosed(Session session) throws Throwable {
            try {
                super.sessionClosed(session);
            }
            finally {
                SimpleTcpClient.this.context.remove(session.getSessionId());
            }
        }

        @Override
        public void exceptionCaught(Session session, Throwable t) throws Throwable {
            try {
                super.exceptionCaught(session, t);
            }
            finally {
                SimpleTcpClient.this.context.remove(session.getSessionId());
            }
        }
    }
}

