/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Session;
import com.firefly.net.buffer.FileRegion;
import com.firefly.net.tcp.AbstractTcpConnection;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.function.Action0;
import com.firefly.utils.function.Action1;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class SecureTcpConnectionImpl
extends AbstractTcpConnection {
    SSLSession sslSession;

    public SecureTcpConnectionImpl(Session session, SSLSession sslSession) {
        super(session);
        this.sslSession = sslSession;
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer, final Action0 succeeded, final Action1<Throwable> failed) {
        try {
            this.sslSession.write(byteBuffer.toArray(BufferUtils.EMPTY_BYTE_BUFFER_ARRAY), new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(String message, final Action0 succeeded, final Action1<Throwable> failed) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset, final Action0 succeeded, final Action1<Throwable> failed) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file, final Action0 succeeded, final Action1<Throwable> failed) {
        try {
            this.sslSession.transferFileRegion(file, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }

                public void failed(Throwable x) {
                    failed.call((Object)x);
                }
            });
        }
        catch (Throwable e) {
            failed.call((Object)e);
        }
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer, final Action0 succeeded) {
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer, final Action0 succeeded) {
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer, final Action0 succeeded) {
        try {
            this.sslSession.write(byteBuffer.toArray(BufferUtils.EMPTY_BYTE_BUFFER_ARRAY), new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(String message, final Action0 succeeded) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset, final Action0 succeeded) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        try {
            this.sslSession.write(byteBuffer, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file, final Action0 succeeded) {
        try {
            this.sslSession.transferFileRegion(file, new Callback(){

                public void succeeded() {
                    succeeded.call();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer byteBuffer) {
        try {
            this.sslSession.write(byteBuffer, Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(ByteBuffer[] byteBuffer) {
        try {
            this.sslSession.write(byteBuffer, Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(Collection<ByteBuffer> byteBuffer) {
        try {
            this.sslSession.write(byteBuffer.toArray(BufferUtils.EMPTY_BYTE_BUFFER_ARRAY), Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(String message) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)StandardCharsets.UTF_8);
        try {
            this.sslSession.write(byteBuffer, Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(String message, String charset) {
        ByteBuffer byteBuffer = BufferUtils.toBuffer((String)message, (Charset)Charset.forName(charset));
        try {
            this.sslSession.write(byteBuffer, Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public TcpConnection write(FileRegion file) {
        try {
            this.sslSession.transferFileRegion(file, Callback.NOOP);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }
}

