/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.event;

import com.firefly.net.Config;
import com.firefly.net.EventManager;
import com.firefly.net.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventManager
implements EventManager {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private Config config;

    public DefaultEventManager(Config config) {
        log.info("create default event manager");
        this.config = config;
    }

    @Override
    public void executeCloseTask(Session session) {
        try {
            this.config.getHandler().sessionClosed(session);
        }
        catch (Throwable t) {
            this.executeExceptionTask(session, t);
        }
    }

    @Override
    public void executeExceptionTask(Session session, Throwable t) {
        try {
            this.config.getHandler().exceptionCaught(session, t);
        }
        catch (Throwable t0) {
            log.error("handler exception", t0);
        }
    }

    @Override
    public void executeOpenTask(Session session) {
        try {
            this.config.getHandler().sessionOpened(session);
        }
        catch (Throwable t) {
            this.executeExceptionTask(session, t);
        }
    }

    @Override
    public void executeReceiveTask(Session session, Object message) {
        try {
            log.debug("CurrentThreadEventManager");
            this.config.getHandler().messageReceived(session, message);
        }
        catch (Throwable t) {
            this.executeExceptionTask(session, t);
        }
    }

    @Override
    public void shutdown() {
    }
}

