/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.buffer;

import com.firefly.net.BufferPool;
import com.firefly.utils.io.BufferUtils;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOBufferPool
implements BufferPool {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static final int POOL_SIZE = 8;
    private final SoftReference<ByteBuffer>[] pool = new SoftReference[8];
    private final boolean directBuffer;

    public IOBufferPool() {
        this(true);
    }

    public IOBufferPool(boolean directBuffer) {
        this.directBuffer = directBuffer;
    }

    @Override
    public ByteBuffer acquire(int size) {
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = this.pool[i];
            if (ref == null) continue;
            ByteBuffer buf = ref.get();
            if (buf == null) {
                this.pool[i] = null;
                continue;
            }
            if (buf.capacity() < size) continue;
            this.pool[i] = null;
            buf.clear();
            return buf;
        }
        int allocateSize = BufferUtils.normalizeBufferSize((int)size);
        log.debug("acquire buffer size: {}", (Object)allocateSize);
        return this.directBuffer ? ByteBuffer.allocateDirect(allocateSize) : ByteBuffer.allocate(allocateSize);
    }

    @Override
    public void release(ByteBuffer buffer) {
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = this.pool[i];
            if (ref != null && ref.get() != null) continue;
            this.pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
        int capacity = buffer.capacity();
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = this.pool[i];
            if (ref == null) {
                this.pool[i] = new SoftReference<ByteBuffer>(buffer);
                return;
            }
            ByteBuffer pooled = ref.get();
            if (pooled == null) {
                this.pool[i] = new SoftReference<ByteBuffer>(buffer);
                return;
            }
            if (pooled.capacity() >= capacity) continue;
            this.pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = this.pool[i];
            if (ref == null || ref.get() == null) continue;
            ++count;
        }
        return count;
    }
}

