/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.firefly.net.Decoder;
import com.firefly.net.Encoder;
import com.firefly.net.Handler;
import com.firefly.utils.function.Func0;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class Config {
    private int timeout = 30000;
    private int asynchronousCorePoolSize = Runtime.getRuntime().availableProcessors();
    private int asynchronousMaximumPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private int asynchronousPoolKeepAliveTime = 15000;
    private String serverName = "firefly-server";
    private String clientName = "firefly-client";
    private Decoder decoder;
    private Encoder encoder;
    private Handler handler;
    private boolean monitorEnable = true;
    private MetricRegistry metrics = new MetricRegistry();
    private Func0<ScheduledReporter> reporterFactory = () -> Slf4jReporter.forRegistry((MetricRegistry)this.metrics).outputTo(LoggerFactory.getLogger((String)"firefly-monitor")).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public int getAsynchronousMaximumPoolSize() {
        return this.asynchronousMaximumPoolSize;
    }

    public void setAsynchronousMaximumPoolSize(int asynchronousMaximumPoolSize) {
        this.asynchronousMaximumPoolSize = asynchronousMaximumPoolSize;
    }

    public int getAsynchronousCorePoolSize() {
        return this.asynchronousCorePoolSize;
    }

    public void setAsynchronousCorePoolSize(int asynchronousCorePoolSize) {
        this.asynchronousCorePoolSize = asynchronousCorePoolSize;
    }

    public int getAsynchronousPoolKeepAliveTime() {
        return this.asynchronousPoolKeepAliveTime;
    }

    public void setAsynchronousPoolKeepAliveTime(int asynchronousPoolKeepAliveTime) {
        this.asynchronousPoolKeepAliveTime = asynchronousPoolKeepAliveTime;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public Func0<ScheduledReporter> getReporterFactory() {
        return this.reporterFactory;
    }

    public void setReporterFactory(Func0<ScheduledReporter> reporterFactory) {
        this.reporterFactory = reporterFactory;
    }

    public boolean isMonitorEnable() {
        return this.monitorEnable;
    }

    public void setMonitorEnable(boolean monitorEnable) {
        this.monitorEnable = monitorEnable;
    }

    public String toString() {
        return "Asynchronous TCP configuration [timeout=" + this.timeout + ", asynchronousCorePoolSize=" + this.asynchronousCorePoolSize + ", asynchronousMaximumPoolSize=" + this.asynchronousMaximumPoolSize + ", asynchronousPoolKeepAliveTime=" + this.asynchronousPoolKeepAliveTime + "]";
    }
}

