/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Decoder;
import com.firefly.net.Handler;
import com.firefly.net.Session;
import com.firefly.net.tcp.AbstractTcpConnection;
import com.firefly.net.tcp.SecureTcpConnectionImpl;
import com.firefly.net.tcp.TcpConnectionImpl;
import java.nio.ByteBuffer;

public abstract class AbstractSimpleHandler
implements Handler {
    static final Decoder decoder = (buf, session) -> {
        Object o = session.getAttachment();
        if (o != null) {
            TcpConnectionImpl c = (TcpConnectionImpl)o;
            if (c.buffer != null) {
                c.buffer.call((Object)buf);
            }
        }
    };
    static final Decoder sslDecoder = (buf, session) -> {
        Object o = session.getAttachment();
        if (o != null && o instanceof SecureTcpConnectionImpl) {
            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
            ByteBuffer plaintext = c.sslSession.read(buf);
            if (plaintext != null && c.sslSession.isHandshakeFinished() && c.buffer != null) {
                c.buffer.call((Object)plaintext);
            }
        }
    };

    @Override
    public void sessionClosed(Session session) throws Throwable {
        Object o = session.getAttachment();
        if (o != null && o instanceof AbstractTcpConnection) {
            AbstractTcpConnection c = (AbstractTcpConnection)o;
            if (c.closeCallback != null) {
                c.closeCallback.call();
            }
        }
    }

    @Override
    public void messageReceived(Session session, Object message) throws Throwable {
    }

    @Override
    public void exceptionCaught(Session session, Throwable t) throws Throwable {
        Object o = session.getAttachment();
        if (o != null && o instanceof AbstractTcpConnection) {
            AbstractTcpConnection c = (AbstractTcpConnection)o;
            if (c.exception != null) {
                c.exception.call((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sslSessionClosed(Session session) throws Throwable {
        Object o;
        try {
            this.sessionClosed(session);
            o = session.getAttachment();
        }
        catch (Throwable throwable) {
            Object o2 = session.getAttachment();
            if (o2 != null && o2 instanceof SecureTcpConnectionImpl) {
                SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o2;
                c.sslSession.close();
            }
            throw throwable;
        }
        if (o != null && o instanceof SecureTcpConnectionImpl) {
            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
            c.sslSession.close();
        }
    }
}

