/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.buffer;

import com.firefly.net.BufferPool;
import com.firefly.utils.io.BufferUtils;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOBufferPool
implements BufferPool {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static final int POOL_SIZE = 8;
    private final SoftReference<ByteBuffer>[] pool = new SoftReference[8];

    @Override
    public final ByteBuffer acquire(int size) {
        SoftReference<ByteBuffer>[] pool = this.pool;
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref == null) continue;
            ByteBuffer buf = ref.get();
            if (buf == null) {
                pool[i] = null;
                continue;
            }
            if (buf.capacity() < size) continue;
            pool[i] = null;
            buf.clear();
            return buf;
        }
        int allocateSize = BufferUtils.normalizeBufferSize((int)size);
        log.debug("acquire read size: {}", (Object)allocateSize);
        ByteBuffer buf = ByteBuffer.allocateDirect(allocateSize);
        buf.clear();
        return buf;
    }

    @Override
    public final void release(ByteBuffer buffer) {
        SoftReference<ByteBuffer>[] pool = this.pool;
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref != null && ref.get() != null) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
        int capacity = buffer.capacity();
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            ByteBuffer pooled = ref.get();
            if (pooled == null) {
                pool[i] = null;
                continue;
            }
            if (pooled.capacity() >= capacity) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
    }
}

