/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.ssl;

import com.firefly.net.SSLEventHandler;
import com.firefly.net.Session;
import com.firefly.net.buffer.FileRegion;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.CountingCallback;
import com.firefly.utils.io.BufferReaderHandler;
import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.eclipse.jetty.alpn.ALPN;

public class SSLSession
implements Closeable {
    protected static final Log log = LogFactory.getInstance().getLog("firefly-system");
    private static final boolean debugMode = Boolean.getBoolean("debugMode");
    protected final Session session;
    protected final SSLEngine sslEngine;
    protected ByteBuffer inNetBuffer;
    protected ByteBuffer requestBuffer;
    protected static final int requestBufferSize = 8192;
    protected static final int writeBufferSize = 8192;
    protected static final ByteBuffer hsBuffer = ByteBuffer.allocate(0);
    protected boolean closed = false;
    protected SSLEngineResult.HandshakeStatus initialHSStatus;
    protected boolean initialHSComplete;
    protected final SSLEventHandler sslEventHandler;

    public SSLSession(SSLContext sslContext, Session session, boolean useClientMode, SSLEventHandler sslEventHandler) throws Throwable {
        this(sslContext, sslContext.createSSLEngine(), session, useClientMode, sslEventHandler, null);
    }

    public SSLSession(SSLContext sslContext, SSLEngine sslEngine, Session session, boolean useClientMode, SSLEventHandler sslEventHandler, ALPN.Provider provider) throws Throwable {
        this.session = session;
        this.requestBuffer = ByteBuffer.allocate(8192);
        this.initialHSComplete = false;
        this.sslEventHandler = sslEventHandler;
        if (provider != null) {
            ALPN.debug = debugMode;
            ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)provider);
        }
        this.sslEngine = sslEngine;
        this.sslEngine.setUseClientMode(useClientMode);
        this.sslEngine.beginHandshake();
        this.initialHSStatus = sslEngine.getHandshakeStatus();
        if (useClientMode) {
            this.doHandshakeResponse();
        }
    }

    protected boolean doHandshake(ByteBuffer receiveBuffer) throws Throwable {
        if (!this.session.isOpen()) {
            this.sslEngine.closeInbound();
            this.initialHSComplete = false;
            return false;
        }
        if (this.initialHSComplete) {
            return this.initialHSComplete;
        }
        if (this.initialHSStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            log.info("session {} handshake success!", new Object[]{this.session.getSessionId()});
            this.initialHSComplete = true;
            this.sslEventHandler.handshakeFinished(this);
            return this.initialHSComplete;
        }
        switch (this.initialHSStatus) {
            case NEED_UNWRAP: {
                this.doHandshakeReceive(receiveBuffer);
                if (this.initialHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.doHandshakeResponse();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)this.initialHSStatus));
            }
        }
        return this.initialHSComplete;
    }

    private void doHandshakeReceive(ByteBuffer receiveBuffer) throws Throwable {
        this.merge(receiveBuffer);
        block10: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            block11: while (true) {
                SSLEngineResult result = this.sslEngine.unwrap(this.inNetBuffer, this.requestBuffer);
                this.initialHSStatus = result.getHandshakeStatus();
                if (log.isDebugEnabled()) {
                    log.debug("session {} handshake receives data, init: {} | ret: {} | complete: {} ", new Object[]{this.session.getSessionId(), this.initialHSStatus, result.getStatus(), this.initialHSComplete});
                }
                switch (result.getStatus()) {
                    case OK: {
                        switch (this.initialHSStatus) {
                            case NOT_HANDSHAKING: {
                                throw new IOException("Not handshaking during initial handshake");
                            }
                            case NEED_TASK: {
                                this.initialHSStatus = this.doTasks();
                                continue block10;
                            }
                            case FINISHED: {
                                log.info("session {} handshake success!", new Object[]{this.session.getSessionId()});
                                this.initialHSComplete = true;
                                this.sslEventHandler.handshakeFinished(this);
                                break block10;
                            }
                        }
                        continue block10;
                    }
                    case BUFFER_UNDERFLOW: {
                        break block10;
                    }
                    case BUFFER_OVERFLOW: {
                        int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(appSize + this.requestBuffer.position());
                        this.requestBuffer.flip();
                        b.put(this.requestBuffer);
                        this.requestBuffer = b;
                        continue block11;
                    }
                    default: {
                        throw new IOException("Received" + (Object)((Object)result.getStatus()) + "during initial handshaking");
                    }
                }
                break;
            }
        }
    }

    protected void doHandshakeResponse() throws Throwable {
        block4: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result;
            ByteBuffer writeBuf = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
            block5: while (true) {
                result = this.sslEngine.wrap(hsBuffer, writeBuf);
                this.initialHSStatus = result.getHandshakeStatus();
                if (log.isDebugEnabled()) {
                    log.debug("session {} handshake response, init: {} | ret: {} | complete: {} ", new Object[]{this.session.getSessionId(), this.initialHSStatus, result.getStatus(), this.initialHSComplete});
                }
                switch (result.getStatus()) {
                    case OK: {
                        if (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.initialHSStatus = this.doTasks();
                        }
                        writeBuf.flip();
                        this.session.write(writeBuf, Callback.NOOP);
                        continue block4;
                    }
                    case BUFFER_OVERFLOW: {
                        int netSize = this.sslEngine.getSession().getPacketBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(writeBuf.position() + netSize);
                        writeBuf.flip();
                        b.put(writeBuf);
                        writeBuf = b;
                        continue block5;
                    }
                }
                break;
            }
            throw new IOException("Received " + (Object)((Object)result.getStatus()) + " during initial handshaking");
        }
    }

    protected void merge(ByteBuffer now) {
        if (!now.hasRemaining()) {
            return;
        }
        if (this.inNetBuffer != null) {
            if (this.inNetBuffer.hasRemaining()) {
                ByteBuffer ret = ByteBuffer.allocate(this.inNetBuffer.remaining() + now.remaining());
                ret.put(this.inNetBuffer).put(now).flip();
                this.inNetBuffer = ret;
            } else {
                this.inNetBuffer = now;
            }
        } else {
            this.inNetBuffer = now;
        }
    }

    protected ByteBuffer getRequestBuffer() {
        this.requestBuffer.flip();
        ByteBuffer buf = ByteBuffer.allocate(this.requestBuffer.remaining());
        buf.put(this.requestBuffer).flip();
        this.requestBuffer = ByteBuffer.allocate(8192);
        return buf;
    }

    protected SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.sslEngine.closeOutbound();
            this.closed = true;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer read(ByteBuffer receiveBuffer) throws Throwable {
        SSLEngineResult result;
        if (!this.doHandshake(receiveBuffer)) {
            return null;
        }
        if (!this.initialHSComplete) {
            throw new IllegalStateException("The initial handshake is not complete.");
        }
        if (log.isDebugEnabled()) {
            log.debug("SSL read current session {} status -> {}", new Object[]{this.session.getSessionId(), this.session.isOpen()});
        }
        this.merge(receiveBuffer);
        if (!this.inNetBuffer.hasRemaining()) {
            return null;
        }
        block5: while (true) {
            result = this.sslEngine.unwrap(this.inNetBuffer, this.requestBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(appSize + this.requestBuffer.position());
                    this.requestBuffer.flip();
                    b.put(this.requestBuffer);
                    this.requestBuffer = b;
                    continue block5;
                }
                case BUFFER_UNDERFLOW: {
                    return null;
                }
                case OK: {
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.doTasks();
                    }
                    if (!this.inNetBuffer.hasRemaining()) return this.getRequestBuffer();
                    continue block5;
                }
            }
            break;
        }
        throw new IOException("sslEngine error during data read: " + (Object)((Object)result.getStatus()));
    }

    public int write(ByteBuffer[] outputBuffers, Callback callback) throws Throwable {
        int ret = 0;
        CountingCallback countingCallback = new CountingCallback(callback, outputBuffers.length);
        for (ByteBuffer outputBuffer : outputBuffers) {
            ret += this.write(outputBuffer, (Callback)countingCallback);
        }
        return ret;
    }

    public int write(ByteBuffer outputBuffer, Callback callback) throws Throwable {
        if (!this.initialHSComplete) {
            throw new IllegalStateException("The initial handshake is not complete.");
        }
        int ret = 0;
        if (!outputBuffer.hasRemaining()) {
            return ret;
        }
        int remain = outputBuffer.remaining();
        block4: while (ret < remain) {
            SSLEngineResult result;
            ByteBuffer writeBuf = ByteBuffer.allocate(8192);
            block5: while (true) {
                result = this.sslEngine.wrap(outputBuffer, writeBuf);
                ret += result.bytesConsumed();
                switch (result.getStatus()) {
                    case OK: {
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.doTasks();
                        }
                        writeBuf.flip();
                        this.session.write(writeBuf, callback);
                        continue block4;
                    }
                    case BUFFER_OVERFLOW: {
                        int netSize = this.sslEngine.getSession().getPacketBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(writeBuf.position() + netSize);
                        writeBuf.flip();
                        b.put(writeBuf);
                        writeBuf = b;
                        continue block5;
                    }
                }
                break;
            }
            throw new IOException("sslEngine error during data write: " + (Object)((Object)result.getStatus()));
        }
        return ret;
    }

    public long transferFileRegion(FileRegion file, Callback callback) throws Throwable {
        long ret = 0L;
        try (FileRegion fileRegion = file;){
            fileRegion.transferTo(callback, new FileBufferReaderHandler(file.getLength()));
        }
        return ret;
    }

    public boolean isHandshakeFinished() {
        return this.initialHSComplete;
    }

    private class FileBufferReaderHandler
    implements BufferReaderHandler {
        private final long len;

        public FileBufferReaderHandler(long len) {
            this.len = len;
        }

        public void readBuffer(ByteBuffer buf, CountingCallback countingCallback, long count) {
            log.debug("write file,  count: {} , lenth: {}", new Object[]{count, this.len});
            try {
                SSLSession.this.write(buf, (Callback)countingCallback);
            }
            catch (Throwable e) {
                log.error("ssl session writing error", e, new Object[0]);
            }
        }
    }
}

