/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.ssl;

import com.firefly.net.SSLContextFactory;
import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.time.Millisecond100Clock;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class AbstractSSLContextFactory
implements SSLContextFactory {
    protected static final Log log = LogFactory.getInstance().getLog("firefly-system");

    public SSLContext getSSLContextWithManager(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        long start = Millisecond100Clock.currentTimeMillis();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        long end = Millisecond100Clock.currentTimeMillis();
        log.info("creating SSL context spends {} ms", new Object[]{end - start});
        return sslContext;
    }

    public SSLContext getSSLContext(InputStream in, String keystorePassword, String keyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        return this.getSSLContext(in, keystorePassword, keyPassword, null, null, null);
    }

    public SSLContext getSSLContext(InputStream in, String keystorePassword, String keyPassword, String keyManagerFactoryType, String trustManagerFactoryType, String sslProtocol) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        long start = Millisecond100Clock.currentTimeMillis();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(in, keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryType == null ? "SunX509" : keyManagerFactoryType);
        kmf.init(ks, keyPassword != null ? keyPassword.toCharArray() : null);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerFactoryType == null ? "SunX509" : trustManagerFactoryType);
        tmf.init(ks);
        SSLContext sslContext = SSLContext.getInstance(sslProtocol == null ? "TLSv1.2" : sslProtocol);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        long end = Millisecond100Clock.currentTimeMillis();
        log.info("creating SSL context spends time in {} ms", new Object[]{end - start});
        return sslContext;
    }
}

