/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.codec;

import com.firefly.net.tcp.codec.MessageHandler;
import com.firefly.utils.function.Action1;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class CharParser
implements MessageHandler<ByteBuffer, String> {
    protected ByteBuffer buffer;
    protected Action1<String> complete;
    private CharsetDecoder decoder;

    public CharParser() {
        this("UTF-8");
    }

    public CharParser(String charset) {
        this.decoder = Charset.forName(charset).newDecoder();
    }

    @Override
    public void complete(Action1<String> complete) {
        this.complete = complete;
    }

    @Override
    public void receive(ByteBuffer buf) {
        this.merge(buf);
        this.parse();
    }

    public void merge(ByteBuffer buf) {
        if (this.buffer != null) {
            if (this.buffer.hasRemaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(this.buffer.remaining() + buf.remaining());
                tmp.put(this.buffer).put(buf).flip();
                this.buffer = tmp;
            } else {
                this.buffer = buf;
            }
        } else {
            this.buffer = buf;
        }
    }

    protected void parse() {
        CharBuffer charBuff = this.allocate();
        while (this.buffer.hasRemaining()) {
            CoderResult r = this.decoder.decode(this.buffer, charBuff, false);
            charBuff.flip();
            if (r.isUnderflow()) {
                if (this.buffer.hasRemaining()) {
                    this.buffer = this.buffer.slice();
                }
                if (!charBuff.hasRemaining()) break;
                this.complete.call((Object)charBuff.toString());
                break;
            }
            if (!r.isOverflow()) continue;
            this.complete.call((Object)charBuff.toString());
            charBuff = this.allocate();
        }
    }

    protected CharBuffer allocate() {
        int expectedLength = (int)((float)this.buffer.remaining() * this.decoder.averageCharsPerByte()) + 1;
        CharBuffer charBuff = CharBuffer.allocate(expectedLength);
        return charBuff;
    }
}

