/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp.aio;

import com.firefly.net.Config;
import com.firefly.net.EventManager;
import com.firefly.net.Worker;
import com.firefly.net.tcp.aio.AsynchronousTcpSession;
import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channel;

public class AsynchronousTcpWorker
implements Worker {
    private static Log log = LogFactory.getInstance().getLog("firefly-system");
    private final Config config;
    final EventManager eventManager;

    public AsynchronousTcpWorker(Config config, EventManager eventManager) {
        this.config = config;
        this.eventManager = eventManager;
    }

    @Override
    public void registerChannel(Channel channel, int sessionId) {
        try {
            AsynchronousSocketChannel socketChannel = (AsynchronousSocketChannel)channel;
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)false);
            AsynchronousTcpSession session = new AsynchronousTcpSession(sessionId, this.config, this.eventManager, socketChannel);
            this.eventManager.executeOpenTask(session);
            session._read();
        }
        catch (IOException e) {
            log.error("socketChannel register error", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void shutdown() {
    }
}

