/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Handler;
import com.firefly.net.Session;
import com.firefly.net.tcp.AbstractTcpConnection;
import com.firefly.net.tcp.SecureTcpConnectionImpl;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.net.tcp.TcpConnectionImpl;
import com.firefly.net.tcp.TcpServerConfiguration;
import com.firefly.net.tcp.aio.AsynchronousTcpServer;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.function.Action0;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action2;
import com.firefly.utils.function.Func1;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.nio.ByteBuffer;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;

public class SimpleTcpServer
extends AbstractLifeCycle {
    protected Action1<TcpConnection> accept;
    protected Action2<Integer, Throwable> failedAcceptance;
    protected Action0 alpnUnsupported;
    protected Func1<List<String>, String> alpnSelectProtocols;
    protected AsynchronousTcpServer server;
    protected TcpServerConfiguration config;

    public SimpleTcpServer() {
        this(new TcpServerConfiguration());
    }

    public SimpleTcpServer(TcpServerConfiguration config) {
        this.config = config;
        this.server = new AsynchronousTcpServer(config);
    }

    public SimpleTcpServer accept(Action1<TcpConnection> accept) {
        this.accept = accept;
        return this;
    }

    public SimpleTcpServer accept(Action1<TcpConnection> accept, Action2<Integer, Throwable> failed) {
        this.accept = accept;
        this.failedAcceptance = failed;
        return this;
    }

    public SimpleTcpServer alpnUnsupported(Action0 alpnUnsupported) {
        this.alpnUnsupported = alpnUnsupported;
        return this;
    }

    public SimpleTcpServer alpnSelectProtocols(Func1<List<String>, String> alpnSelectProtocols) {
        this.alpnSelectProtocols = alpnSelectProtocols;
        return this;
    }

    public void listen(String host, int port) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.start();
    }

    protected void init() {
        if (!this.config.isSecureConnectionEnabled()) {
            this.config.setDecoder((buf, session) -> {
                Object o = session.getAttachment();
                if (o != null) {
                    TcpConnectionImpl c = (TcpConnectionImpl)o;
                    if (c.buffer != null) {
                        c.buffer.call((Object)buf);
                    }
                }
            });
            this.config.setHandler(new AbstractHandler(){

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    TcpConnectionImpl c = new TcpConnectionImpl(session);
                    session.attachObject(c);
                    if (SimpleTcpServer.this.accept != null) {
                        SimpleTcpServer.this.accept.call((Object)c);
                    }
                }
            });
        } else {
            this.config.setDecoder((buf, session) -> {
                Object o = session.getAttachment();
                if (o != null && o instanceof SecureTcpConnectionImpl) {
                    SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                    ByteBuffer plaintext = c.sslSession.read(buf);
                    if (plaintext != null && c.sslSession.isHandshakeFinished() && c.buffer != null) {
                        c.buffer.call((Object)plaintext);
                    }
                }
            });
            this.config.setHandler(new AbstractHandler(){
                private SSLContext sslContext;
                {
                    this.sslContext = SimpleTcpServer.this.config.getSslContextFactory().getSSLContext();
                }

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    final SSLEngine sslEngine = this.sslContext.createSSLEngine();
                    SSLSession sslSession = new SSLSession(this.sslContext, sslEngine, session, false, ssl -> {
                        Object o = session.getAttachment();
                        if (o != null && o instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                            if (SimpleTcpServer.this.accept != null) {
                                SimpleTcpServer.this.accept.call((Object)c);
                            }
                        }
                    }, (ALPN.Provider)new ALPN.ServerProvider(){

                        public void unsupported() {
                            try {
                                SimpleTcpServer.this.alpnUnsupported.call();
                            }
                            finally {
                                ALPN.remove((SSLEngine)sslEngine);
                            }
                        }

                        public String select(List<String> protocols) {
                            try {
                                String string = (String)SimpleTcpServer.this.alpnSelectProtocols.call(protocols);
                                return string;
                            }
                            finally {
                                ALPN.remove((SSLEngine)sslEngine);
                            }
                        }
                    });
                    SecureTcpConnectionImpl c = new SecureTcpConnectionImpl(session, sslSession);
                    session.attachObject(c);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sessionClosed(Session session) throws Throwable {
                    Object o;
                    try {
                        super.sessionClosed(session);
                        o = session.getAttachment();
                    }
                    catch (Throwable throwable) {
                        Object o2 = session.getAttachment();
                        if (o2 != null && o2 instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o2;
                            c.sslSession.close();
                        }
                        throw throwable;
                    }
                    if (o != null && o instanceof SecureTcpConnectionImpl) {
                        SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                        c.sslSession.close();
                    }
                }
            });
        }
        this.server.listen(this.config.getHost(), this.config.getPort());
    }

    protected void destroy() {
        this.server.stop();
    }

    public abstract class AbstractHandler
    implements Handler {
        @Override
        public void sessionClosed(Session session) throws Throwable {
            Object o = session.getAttachment();
            if (o != null && o instanceof AbstractTcpConnection) {
                AbstractTcpConnection c = (AbstractTcpConnection)o;
                if (c.closeCallback != null) {
                    c.closeCallback.call();
                }
            }
        }

        @Override
        public void messageRecieved(Session session, Object message) throws Throwable {
        }

        @Override
        public void exceptionCaught(Session session, Throwable t) throws Throwable {
            Object o = session.getAttachment();
            if (o != null && o instanceof AbstractTcpConnection) {
                AbstractTcpConnection c = (AbstractTcpConnection)o;
                if (c.exception != null) {
                    c.exception.call((Object)t);
                }
            }
        }

        @Override
        public void failedAcceptingSession(Integer sessionId, Throwable t) throws Throwable {
            if (SimpleTcpServer.this.failedAcceptance != null) {
                SimpleTcpServer.this.failedAcceptance.call((Object)sessionId, (Object)t);
            }
        }
    }
}

