/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.net.tcp;

import com.firefly.net.Handler;
import com.firefly.net.Session;
import com.firefly.net.tcp.AbstractTcpConnection;
import com.firefly.net.tcp.SecureTcpConnectionImpl;
import com.firefly.net.tcp.TcpConfiguration;
import com.firefly.net.tcp.TcpConnection;
import com.firefly.net.tcp.TcpConnectionImpl;
import com.firefly.net.tcp.aio.AsynchronousTcpClient;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.concurrent.FuturePromise;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.function.Action0;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Func0;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;

public class SimpleTcpClient
extends AbstractLifeCycle {
    protected Action0 alpnUnsupported;
    protected Action1<String> alpnSelected;
    protected Func0<List<String>> alpnProtocols;
    protected AsynchronousTcpClient client;
    protected TcpConfiguration config;
    protected Map<Integer, ClientContext> context = new ConcurrentHashMap<Integer, ClientContext>();

    public SimpleTcpClient() {
        this(new TcpConfiguration());
    }

    public SimpleTcpClient(TcpConfiguration config) {
        this.client = new AsynchronousTcpClient(config);
        this.config = config;
    }

    public SimpleTcpClient alpnUnsupported(Action0 alpnUnsupported) {
        this.alpnUnsupported = alpnUnsupported;
        return this;
    }

    public SimpleTcpClient alpnSelected(Action1<String> alpnSelected) {
        this.alpnSelected = alpnSelected;
        return this;
    }

    public SimpleTcpClient alpnProtocols(Func0<List<String>> alpnProtocols) {
        this.alpnProtocols = alpnProtocols;
        return this;
    }

    public FuturePromise<TcpConnection> connect(String host, int port) {
        FuturePromise promise = new FuturePromise();
        this.connect(host, port, (Promise<TcpConnection>)promise);
        return promise;
    }

    public void connect(String host, int port, final Action1<TcpConnection> conn) {
        Promise<TcpConnection> promise = new Promise<TcpConnection>(){

            public void succeeded(TcpConnection result) {
                conn.call((Object)result);
            }
        };
        this.connect(host, port, promise);
    }

    public void connect(String host, int port, final Action1<TcpConnection> conn, final Action1<Throwable> failed) {
        Promise<TcpConnection> promise = new Promise<TcpConnection>(){

            public void succeeded(TcpConnection result) {
                conn.call((Object)result);
            }

            public void failed(Throwable x) {
                failed.call((Object)x);
            }
        };
        this.connect(host, port, promise);
    }

    public void connect(String host, int port, Promise<TcpConnection> promise) {
        this.start();
        int sessionId = this.client.connect(host, port);
        ClientContext ctx = new ClientContext();
        ctx.promise = promise;
        this.context.put(sessionId, ctx);
    }

    protected void init() {
        if (!this.config.isSecureConnectionEnabled()) {
            this.config.setDecoder((buf, session) -> {
                Object o = session.getAttachment();
                if (o != null) {
                    TcpConnectionImpl c = (TcpConnectionImpl)o;
                    if (c.buffer != null) {
                        c.buffer.call((Object)buf);
                    }
                }
            });
            this.config.setHandler(new AbstractHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sessionOpened(Session session) throws Throwable {
                    TcpConnectionImpl c = new TcpConnectionImpl(session);
                    session.attachObject(c);
                    try {
                        ClientContext ctx = SimpleTcpClient.this.context.get(session.getSessionId());
                        if (ctx != null && ctx.promise != null) {
                            ctx.promise.succeeded((Object)c);
                        }
                    }
                    finally {
                        SimpleTcpClient.this.context.remove(session.getSessionId());
                    }
                }
            });
        } else {
            this.config.setDecoder((buf, session) -> {
                Object o = session.getAttachment();
                if (o != null && o instanceof SecureTcpConnectionImpl) {
                    SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                    ByteBuffer plaintext = c.sslSession.read(buf);
                    if (plaintext != null && c.sslSession.isHandshakeFinished() && c.buffer != null) {
                        c.buffer.call((Object)plaintext);
                    }
                }
            });
            this.config.setHandler(new AbstractHandler(){
                private SSLContext sslContext;
                {
                    this.sslContext = SimpleTcpClient.this.config.getSslContextFactory().getSSLContext();
                }

                @Override
                public void sessionOpened(Session session) throws Throwable {
                    SSLEngine sslEngine = this.sslContext.createSSLEngine();
                    SSLSession sslSession = new SSLSession(this.sslContext, sslEngine, session, true, ssl -> {
                        Object o = session.getAttachment();
                        if (o != null && o instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                            try {
                                ClientContext ctx = SimpleTcpClient.this.context.get(session.getSessionId());
                                if (ctx != null && ctx.promise != null) {
                                    ctx.promise.succeeded((Object)c);
                                }
                            }
                            finally {
                                SimpleTcpClient.this.context.remove(session.getSessionId());
                            }
                        }
                    }, (ALPN.Provider)new ALPN.ClientProvider(){

                        public List<String> protocols() {
                            if (SimpleTcpClient.this.alpnProtocols != null) {
                                return (List)SimpleTcpClient.this.alpnProtocols.call();
                            }
                            return null;
                        }

                        public void unsupported() {
                            if (SimpleTcpClient.this.alpnUnsupported != null) {
                                SimpleTcpClient.this.alpnUnsupported.call();
                            }
                        }

                        public void selected(String protocol) {
                            if (SimpleTcpClient.this.alpnSelected != null) {
                                SimpleTcpClient.this.alpnSelected.call((Object)protocol);
                            }
                        }
                    });
                    SecureTcpConnectionImpl c = new SecureTcpConnectionImpl(session, sslSession);
                    session.attachObject(c);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sessionClosed(Session session) throws Throwable {
                    Object o;
                    try {
                        super.sessionClosed(session);
                        o = session.getAttachment();
                    }
                    catch (Throwable throwable) {
                        Object o2 = session.getAttachment();
                        if (o2 != null && o2 instanceof SecureTcpConnectionImpl) {
                            SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o2;
                            c.sslSession.close();
                        }
                        throw throwable;
                    }
                    if (o != null && o instanceof SecureTcpConnectionImpl) {
                        SecureTcpConnectionImpl c = (SecureTcpConnectionImpl)o;
                        c.sslSession.close();
                    }
                }
            });
        }
    }

    protected void destroy() {
        this.client.stop();
    }

    public abstract class AbstractHandler
    implements Handler {
        @Override
        public void messageRecieved(Session session, Object message) throws Throwable {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedOpeningSession(Integer sessionId, Throwable t) throws Throwable {
            try {
                ClientContext ctx = SimpleTcpClient.this.context.get(sessionId);
                if (ctx != null && ctx.promise != null) {
                    ctx.promise.failed(t);
                }
            }
            finally {
                SimpleTcpClient.this.context.remove(sessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionClosed(Session session) throws Throwable {
            try {
                Object o = session.getAttachment();
                if (o != null && o instanceof AbstractTcpConnection) {
                    AbstractTcpConnection c = (AbstractTcpConnection)o;
                    if (c.closeCallback != null) {
                        c.closeCallback.call();
                    }
                }
            }
            finally {
                SimpleTcpClient.this.context.remove(session.getSessionId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exceptionCaught(Session session, Throwable t) throws Throwable {
            try {
                Object o = session.getAttachment();
                if (o != null && o instanceof AbstractTcpConnection) {
                    AbstractTcpConnection c = (AbstractTcpConnection)o;
                    if (c.exception != null) {
                        c.exception.call((Object)t);
                    }
                }
            }
            finally {
                SimpleTcpClient.this.context.remove(session.getSessionId());
            }
        }
    }

    public class ClientContext {
        Promise<TcpConnection> promise;
        TcpConnection connection;
    }
}

