/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.time;

import com.firefly.utils.lang.AbstractLifeCycle;

public class TimeProvider
extends AbstractLifeCycle {
    private final long interval;
    private volatile long current = System.currentTimeMillis();

    public TimeProvider(long interval) {
        this.interval = interval;
    }

    public long currentTimeMillis() {
        return this.current;
    }

    @Override
    protected void init() {
        this.start = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (TimeProvider.this.start) {
                    try {
                        Thread.sleep(TimeProvider.this.interval);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    TimeProvider.this.current = System.currentTimeMillis();
                }
            }
        }, "filefly time provider " + this.interval + "ms").start();
    }

    @Override
    protected void destroy() {
        this.start = false;
    }
}

