/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.time;

import com.firefly.utils.concurrent.Scheduler;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HashTimeWheel
extends AbstractLifeCycle {
    private int maxTimers = 60;
    private long interval = 1000L;
    private ConcurrentLinkedQueue<TimerTask>[] timerSlots;
    private volatile int currentSlot = 0;

    public int getMaxTimers() {
        return this.maxTimers;
    }

    public void setMaxTimers(int maxTimers) {
        this.maxTimers = maxTimers;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public Future add(long delay, Runnable run) {
        int curSlot = this.currentSlot;
        int ticks = delay > this.interval ? (int)(delay / this.interval) : 1;
        int index = (curSlot + ticks % this.maxTimers) % this.maxTimers;
        int round = (ticks - 1) / this.maxTimers;
        TimerTask task = new TimerTask(round, run);
        this.timerSlots[index].add(task);
        return new Future(this, index, task);
    }

    private final boolean remove(TimerTask task, int index) {
        return this.timerSlots[index].remove(task);
    }

    @Override
    protected void init() {
        this.timerSlots = new ConcurrentLinkedQueue[this.maxTimers];
        for (int i = 0; i < this.timerSlots.length; ++i) {
            this.timerSlots[i] = new ConcurrentLinkedQueue();
        }
        this.start = true;
        new Thread((Runnable)new Worker(), "firefly time wheel").start();
    }

    @Override
    protected void destroy() {
        this.start = false;
        this.timerSlots = null;
    }

    public static class Future
    implements Scheduler.Future {
        private HashTimeWheel timeWheel;
        private int index;
        private TimerTask task;

        public Future(HashTimeWheel timeWheel, int index, TimerTask task) {
            this.timeWheel = timeWheel;
            this.index = index;
            this.task = task;
        }

        @Override
        public boolean cancel() {
            return this.timeWheel.remove(this.task, this.index);
        }
    }

    private final class TimerTask {
        private int round;
        private Runnable run;

        public TimerTask(int round, Runnable run) {
            this.round = round;
            this.run = run;
        }

        public boolean runTask() {
            if (this.round == 0) {
                this.run.run();
                return true;
            }
            --this.round;
            return false;
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            while (HashTimeWheel.this.start) {
                int currentSlotTemp = HashTimeWheel.this.currentSlot;
                ConcurrentLinkedQueue timerSlot = HashTimeWheel.this.timerSlots[currentSlotTemp++];
                currentSlotTemp %= HashTimeWheel.this.timerSlots.length;
                Iterator iterator = timerSlot.iterator();
                while (iterator.hasNext()) {
                    if (!((TimerTask)iterator.next()).runTask()) continue;
                    iterator.remove();
                }
                try {
                    Thread.sleep(HashTimeWheel.this.interval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                HashTimeWheel.this.currentSlot = currentSlotTemp;
            }
        }
    }
}

